using System;
using System.Drawing;
using System.Collections;
using System.Configuration;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Windows.Forms;
using System.Data;
using MarcObjects;

namespace ThinPlayerClient
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class ThinPlayerClientForm : System.Windows.Forms.Form
	{
		ThinPlayerClient PlayerObj = null;
		ServiceCore Core = null;
		bool PlayerRegistered = false;

		private AxDMC2.AxDMC axDMC1;
		private System.Timers.Timer PingTimer;
		private System.Windows.Forms.Label ServerMessage;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ThinPlayerClientForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			// Register the channel we're going to use to communicate
			// with the server
			TcpChannel channel = new TcpChannel(0);
			ChannelServices.RegisterChannel(channel);

			// Next try to connect
			RegisterPlayer();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ThinPlayerClientForm));
			this.axDMC1 = new AxDMC2.AxDMC();
			this.PingTimer = new System.Timers.Timer();
			this.ServerMessage = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.axDMC1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.PingTimer)).BeginInit();
			this.SuspendLayout();
			// 
			// axDMC1
			// 
			this.axDMC1.Enabled = true;
			this.axDMC1.Location = new System.Drawing.Point(304, 8);
			this.axDMC1.Name = "axDMC1";
			this.axDMC1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axDMC1.OcxState")));
			this.axDMC1.Size = new System.Drawing.Size(32, 32);
			this.axDMC1.TabIndex = 0;
			// 
			// PingTimer
			// 
			this.PingTimer.Enabled = true;
			this.PingTimer.Interval = 4000;
			this.PingTimer.SynchronizingObject = this;
			this.PingTimer.Elapsed += new System.Timers.ElapsedEventHandler(this.PingTimer_Elapsed);
			// 
			// ServerMessage
			// 
			this.ServerMessage.Location = new System.Drawing.Point(8, 32);
			this.ServerMessage.Name = "ServerMessage";
			this.ServerMessage.Size = new System.Drawing.Size(320, 32);
			this.ServerMessage.TabIndex = 1;
			// 
			// ThinPlayerClientForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(336, 70);
			this.Controls.Add(this.ServerMessage);
			this.Controls.Add(this.axDMC1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Name = "ThinPlayerClientForm";
			this.Text = "Player Client";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.PlayerClientForm_Closing);
			this.Load += new System.EventHandler(this.PlayerClientForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.axDMC1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.PingTimer)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new ThinPlayerClientForm());
		}

		void RegisterPlayer()
		{
			// We need to connect with the server and register ourselves as 
			// a valid player.
			try
			{
				// TODO: Update this to properly locate the server
				string ServiceCorePath = String.Format("tcp://athlonxp:9933/ServiceCore");
				Core = (ServiceCore)Activator.GetObject(typeof(ServiceCore), ServiceCorePath);
				MusicLibrary MusicLib = Core.GetMusicLibrary();
				MusicLib.GetUsersList();

				// Create the player client object, cast it to a PlayerClient, and
				// pass in a reference to it.
				string PlayerName = ConfigurationSettings.AppSettings["PlayerName"];
				if (PlayerName == null)
				{
					PlayerName = "Music Player";
				};

				PlayerObj = new ThinPlayerClient(this, PlayerName, Core);
				PlayerClient player = PlayerObj;
				Core.RegisterPlayer(ref player);

				PlayerRegistered = true;
				ServerMessage.Text = "Connected";

				return;
			} 
			catch (Exception ex)
			{
				ServerMessage.Text = ex.Message;

				Core = null;
				PlayerObj = null;
				return;
			};
		}

		private void PlayerClientForm_Load(object sender, System.EventArgs e)
		{
			axDMC1.InitBASS((int)this.Handle, 44100, false, false);
		}

		private void PlayerClientForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
#if false
			if (Core != null)
			{
				Core.UnregisterPlayer(PlayerObj);
			}
#endif
			axDMC1.TerminateBASS();
		}

		public void PlaySong(string FullPath)
		{
			axDMC1.StopStream();
			axDMC1.OpenStream(FullPath);
			axDMC1.PlayStream(false);
		}

		public void Control(string Command)
		{
			switch (Command)
			{
				case "Stop":
					axDMC1.StopStream();
					break;

				case "Skip":
					int currentPos = axDMC1.StreamPos;
					axDMC1.StreamPos = currentPos + (20000*30*2*2);	
					break;
			};
		}

		private void PingTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			if (PlayerRegistered)
			{
				try
				{
					Core.Ping();
				} 
				catch (Exception)
				{
					PlayerRegistered = false;
					Core = null;
					ServerMessage.Text = "Connection to server lost";
				};
			} 
			else
			{
				RegisterPlayer();
			};
		}
	}
}
