using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Runtime.Serialization.Formatters;
using MarcObjects;

namespace MarcService
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private ServiceCore Core;
		private System.Windows.Forms.NotifyIcon notifyIcon;
		private System.Timers.Timer PingTimer;
		private System.ComponentModel.IContainer components;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MainForm));
			this.label1 = new System.Windows.Forms.Label();
			this.notifyIcon = new System.Windows.Forms.NotifyIcon(this.components);
			this.PingTimer = new System.Timers.Timer();
			((System.ComponentModel.ISupportInitialize)(this.PingTimer)).BeginInit();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(248, 32);
			this.label1.TabIndex = 0;
			this.label1.Text = "This standalone GUI application will be replaced with a service; thus the GUI is " +
				"irrelevant.";
			// 
			// notifyIcon
			// 
			this.notifyIcon.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIcon.Icon")));
			this.notifyIcon.Text = "notifyIcon";
			this.notifyIcon.Visible = true;
			this.notifyIcon.DoubleClick += new System.EventHandler(this.notifyIcon_DoubleClick);
			// 
			// PingTimer
			// 
			this.PingTimer.Enabled = true;
			this.PingTimer.Interval = 180000;
			this.PingTimer.SynchronizingObject = this;
			this.PingTimer.Elapsed += new System.Timers.ElapsedEventHandler(this.PingTimer_Elapsed);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(256, 46);
			this.Controls.Add(this.label1);
			this.Name = "MainForm";
			this.ShowInTaskbar = false;
			this.Text = "Marc Service";
			this.WindowState = System.Windows.Forms.FormWindowState.Minimized;
			this.Load += new System.EventHandler(this.MainForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.PingTimer)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			try
			{
				BinaryServerFormatterSinkProvider provider = new BinaryServerFormatterSinkProvider();
				provider.TypeFilterLevel = TypeFilterLevel.Full;

				Hashtable ht = new Hashtable();
				ht.Add("port", 9933);

				TcpChannel channel = new TcpChannel(ht, null, provider);

				ChannelServices.RegisterChannel( channel );

				// Create and register the office
				Core = new ServiceCore(); 
				ObjRef or = RemotingServices.Marshal(Core, "ServiceCore");
			} 
			catch (Exception)
			{
				MessageBox.Show("Unable to bind to port 9933; server is probably already running");
				Application.Exit();
				return;
			};
		}

		private void notifyIcon_DoubleClick(object sender, System.EventArgs e)
		{
			this.WindowState = FormWindowState.Normal;
		}

		private void PingTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			Core.PingPlayers();
		}
	}
}
