using System;
using System.Runtime.Remoting.Messaging;

namespace MarcObjects
{
	/// <summary>
	/// This object represents a music player; it's base lives in the player
	/// itself and it's passed by reference to the core stuff.
	/// </summary>
	public abstract class PlayerClient : MarshalByRefObject
	{
		// This is the service we're connected to
		ServiceCore Core;
		int PingSequence = 0;

		// The public name for this player
		public string Name;

		public PlayerClient(ServiceCore Core)
		{
			this.Core = Core;
		}

		public int Ping()
		{
			return PingSequence++;
		}

		[OneWayAttribute]
		public abstract void PlaySong(string FullPath);

		[OneWayAttribute]
		public abstract void Control(string Message, string Args);
	}
}
