using System;
using System.Collections;
using System.Collections.Specialized;
using System.Runtime.Remoting.Messaging;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.IO;
using mp3info;
using MarcObjects;
using System.Windows.Forms;

namespace MarcObjects
{
	/// <summary>
	/// Summary description for MusicLibrary.
	/// </summary>
	public class MusicLibrary : MarshalByRefObject
	{
		string LastExceptionMessage;

		SqlConnection cn;
		string ConnectionString = "server=athlonxp\\vsdotnet2003;uid=musiclib;pwd=;database=MusicLib";
		
		public MusicLibrary()
		{
		}

		public override Object InitializeLifetimeService()
		{
			return null;
		}

		void LogException(Exception ex)
		{
//		MessageBox.Show("ex: " + ex.Message);
			LastExceptionMessage = ex.Message;
		}

		void DupeRecover()
		{
				StringCollection names = new StringCollection();
				ArrayList ids = new ArrayList();				

				DataSet ds = new DataSet();
				SqlDataAdapter adapt = new SqlDataAdapter("select song_ID, song_Bytes, song_Filename from Songs where song_Missing = 1", cn);
				adapt.Fill(ds);

				ArrayList DeleteIDs = new ArrayList();
				ArrayList RestoreIDs = new ArrayList();

				foreach (DataRow row in ds.Tables[0].Rows)
				{
					SqlCommand workcmd = new SqlCommand("select song_ID from Songs where song_Filename = @FileName and song_Missing = 0", cn);
					workcmd.Parameters.Add("@Filename", row["song_Filename"]);
					SqlDataReader workrdr = workcmd.ExecuteReader();
					if (workrdr.Read())
					{
						int origID = (int)row["song_ID"];
						int dupeID = (int)workrdr["song_ID"];

						DeleteIDs.Add(dupeID);
						RestoreIDs.Add(origID);

						// Delete the duplicate, enable the original
						workrdr.Close();	
					};

					workrdr.Close();
				};

				foreach (int songid in DeleteIDs)
				{
					RemoveSongFromDatabase(songid);
				}

				foreach (int songid in RestoreIDs)
				{
					SqlCommand cmd = new SqlCommand("update songs set song_Missing = 0 where song_ID = " + songid.ToString(), cn);
					cmd.ExecuteNonQuery();
				}
		}

		public bool Open()
		{
			try
			{
				cn = new SqlConnection(ConnectionString);
				cn.Open();

				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public void Save()
		{
		}

		public bool AddFolder(string Folder)
		{
			try
			{
				SqlCommand cmd = new SqlCommand("insert into folders (folder_Path) values (@Path)", cn);
				cmd.Parameters.Add("@Path", Folder);
				cmd.ExecuteNonQuery();
				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public bool CreatePlaylist(int UserID, string PlaylistName)
		{
			try
			{
				SqlCommand cmd = new SqlCommand("insert into Playlists (playlist_Name, playlist_OwnerID) values (@Name, @OwnerID)", cn);
				cmd.Parameters.Add("@Name", PlaylistName);
				cmd.Parameters.Add("@OwnerID", UserID);
				cmd.ExecuteNonQuery();
				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public bool AddSongToPlaylist(int UserID, string FullPath, int PlaylistID)
		{
			return AddSongToPlaylist(UserID, GetSongID(FullPath), PlaylistID);
		}

		public bool AddSongToPlaylist(int UserID, int SongID, int PlaylistID)
		{
			try
			{
				// Get the ID of the playlist we're adding to
				if (PlaylistID == 0)
				{
					// Invalid playlist
					return false;
				};

				// See if it's already on the playlist
				SqlCommand cmd = new SqlCommand("Select count(playlistentry_ID) from PlaylistEntries where playlistentry_PlaylistID = @PlaylistID and playlistentry_SongID = @SongID", cn);
				cmd.Parameters.Add("@SongID", SongID);
				cmd.Parameters.Add("@PlaylistID", PlaylistID);
				object o = cmd.ExecuteScalar();
				if (o != null && Int32.Parse(o.ToString()) == 0)
				{
					// It's not already there; add it
					cmd.CommandText = "Insert into PlaylistEntries (playlistentry_SongID, playlistentry_PlaylistID, playlistentry_Sequence) values (@SongID, @PlaylistID, 0)";
					cmd.ExecuteNonQuery();
				};

				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public bool DeletePlaylist(int UserID, string PlaylistName)
		{
			int PlaylistID = GetPlaylistID(UserID, PlaylistName);
			if (PlaylistID != 0)
			{
				// Delete it by ID
				return DeletePlaylist(PlaylistID);
			} 
			else
			{
				// Couldn't find the playlist
				return false;
			};
		}

		public bool DeletePlaylist(int PlaylistID)
		{
			try
			{
				// Delete all the playlist entries
				SqlCommand cmd = new SqlCommand("Delete from PlaylistEntries where playlistentry_PlaylistID = " + PlaylistID.ToString(), cn);
				cmd.ExecuteNonQuery();

				// Delete the playlist itself
				cmd.CommandText = "Delete from Playlists where playlist_ID = " + PlaylistID.ToString();
				cmd.ExecuteNonQuery();
			
				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			}
		}

		public bool RemoveSongFromPlaylist(int UserID, string FullPath, int PlaylistID)
		{
			return RemoveSongFromPlaylist(UserID, GetSongID(FullPath), PlaylistID);
		}

		public bool RemoveSongFromPlaylist(int UserID, int SongID, int PlaylistID)
		{
			try
			{
				// Get the ID of the playlist we're adding to
				if (PlaylistID == 0)
				{
					// Invalid playlist
					return false;
				};

				// See if it's already on the playlist
				SqlCommand cmd = new SqlCommand("Select count(playlistentry_ID) from PlaylistEntries where playlistentry_PlaylistID = @PlaylistID and playlistentry_SongID = @SongID", cn);
				cmd.Parameters.Add("@SongID", SongID);
				cmd.Parameters.Add("@PlaylistID", PlaylistID);
				object o = cmd.ExecuteScalar();
				if (o != null && Int32.Parse(o.ToString()) > 0)
				{
					// It's there; remove it
					cmd.CommandText = "Delete from PlaylistEntries where (playlistentry_PlaylistID = @PlaylistID) And (playlistentry_SongID = @SongID)";
					cmd.ExecuteNonQuery();
				};

				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		// Enumerate playlists
		public StringCollection GetPlaylistList(int UserID)
		{
			try
			{
				StringCollection coll = new StringCollection();
				string SqlQuery = String.Format("Select playlist_Name from Playlists where playlist_OwnerID = {0}", UserID);

				// Either return the collection or return NULL
				if (SqlQueryStringList(coll, SqlQuery))
				{
					return coll;
				} 
				else
				{
					return null;
				};
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return null;
			};
		}

		public bool AddTag(string TagName)
		{
			try
			{
				SqlCommand cmd = new SqlCommand("insert into Tags (tag_Name) values (@Name)", cn);
				cmd.Parameters.Add("@Name", TagName);
				cmd.ExecuteNonQuery();
				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public string[] GetFolderList()
		{
			try
			{
				StringCollection folders = new StringCollection();

				SqlCommand cmd = new SqlCommand("Select * from Folders", cn);
				SqlDataReader rdr = cmd.ExecuteReader();
				while (rdr.Read())
				{
					folders.Add(rdr["folder_Path"].ToString());
				};

				// Copy into a string array to return 
				string[] array = new string[folders.Count];
				folders.CopyTo(array, 0);
				return array;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return null;
			};
		}

		void RecurseScan(StringCollection filesFound, string BasePath)
		{
			try
			{
				string[] files = System.IO.Directory.GetFiles(BasePath, "*.mp3");
				foreach (string file in files)
				{
					string Final = file;
					filesFound.Add(Final);
				};

				string[] folders = System.IO.Directory.GetDirectories(BasePath);
				foreach (string folder in folders)
				{
					string Final = folder + "\\";
					RecurseScan(filesFound, Final);
				};
			} 
			catch (Exception ex)
			{
				LogException(ex);
			};
		}

		void ScanFolder(string BasePath)
		{
			try
			{
				// Scan the files in this folder... try to match any file 
				// we found with an exact match or a moved file match.. add
				// the rest as new files.
				StringCollection filesFound = new StringCollection();

				RecurseScan(filesFound, BasePath);

				foreach (string songpath in filesFound)
				{
					if (songpath.StartsWith(BasePath))
					{
						AddSong(BasePath, songpath.Substring(BasePath.Length+1));
					};
				}
			} 
			catch (Exception ex)
			{
				LogException(ex);
			};
		}

		void AddSong(string BasePath, string SongPath)
		{
			// Build the full path to the song
			string FullPath = BasePath;
			if (!FullPath.EndsWith("\\"))
				FullPath += "\\";
			FullPath += SongPath;

			// Quick check to see if this full path exists
			SqlCommand cmd = new SqlCommand("Select Count(song_ID) from Songs where song_Missing = 0 and song_FullPath = @FullPath", cn);
			cmd.Parameters.Add("@FullPath", FullPath);
			int count = (int)cmd.ExecuteScalar();
			if (count > 0)
			{
				// Song already exists
				return;
			};

			// See if we have a missing song that this one matches
			FileInfo fi = new FileInfo(FullPath);
			cmd.CommandText = String.Format("Select song_ID from Songs where " +
					"UPPER(song_Filename) = UPPER(@FileName)");
			cmd.Parameters.Add("@FileName", fi.Name);

			object result = cmd.ExecuteScalar();
			if (result != null)
			{
				// We found an orphan!
				int SongID = (int)result;
				cmd.CommandText = "Update Songs set song_Missing=0, song_FullPath=@FullPath where song_ID = " + SongID.ToString();
				cmd.ExecuteNonQuery();
				return;
			};

			// Find the "New" tag ID so we can associate new songs with it
			int NewTagID = 0;
			try
			{
				NewTagID = GetTagID("New");
				if (NewTagID == 0)
				{
					if (AddTag("New"))
					{
						NewTagID = GetTagID("New");
					};
				};
			} 
			catch (Exception)
			{
				NewTagID = 0;
			};

			try
			{
				// Convert the path to the song name into simply the song name
				string FileName = SongPath;
				int endpart = FileName.LastIndexOf('\\');
				if (endpart != -1 && (endpart != FileName.Length - 1))
				{
					FileName = FileName.Substring(endpart+1);
				};

				// Get the file info
				if (fi.Exists && (fi.Length > 0))
				{
					cmd = new SqlCommand("insert into songs (song_Filename, song_FullPath, song_OwnerID, song_Bytes) values (@Filename, @FullPath, @OwnerID, @Bytes); select @@IDENTITY as NewIdentity", cn);

					cmd.Parameters.Add("@Filename", FileName);
					cmd.Parameters.Add("@FullPath", FullPath);
					cmd.Parameters.Add("@OwnerID", 3);
					cmd.Parameters.Add("@Bytes", fi.Length);

					// Execute it
					object o = cmd.ExecuteScalar();

					// If it succeeded, we got back the identity of the new song;
					// now set the New tag for this song
					if (o != null)
					{
						int NewSongID = Int32.Parse(o.ToString());
						SetTag(NewSongID, NewTagID);
					};
				};

			} 
			catch (Exception ex)
			{
				LogException(ex);
				return;
			};
		}

		public void ScanAllFolders()
		{
#if false
			// Temporary fix - find all the "New" songs that have
			// songs already in the database
			DataTable newTable = new DataTable();
			SqlDataAdapter adapty = new SqlDataAdapter("SELECT Songs.song_ID, Songs.song_FullPath, Songs.song_Filename, Songs.song_Bytes FROM Songs INNER JOIN TagAssoc ON Songs.song_ID = TagAssoc.tagassoc_SongID WHERE (TagAssoc.tagassoc_TagID = 27) and song_missing = 0", cn);
			adapty.Fill(newTable);
			foreach (DataRow row in newTable.Rows)
			{
				// Ok for each of these song filenames, see if we can find
				// a missing one with the same filename
				int songid = (int)row["song_id"];
				string query = "select * from songs where song_missing = 1 and song_filename = @filename";
				SqlCommand queryCmd = new SqlCommand(query, cn);
				queryCmd.Parameters.Add("@filename", row["song_filename"]);
				SqlDataReader rdr = queryCmd.ExecuteReader();
				if (rdr.Read())
				{
					// Found one - delete the current one and mark this
					// one as not missing (and copy the path over)
					int keepId = (int)rdr["song_id"];
	
					rdr.Close();

					// Have to delete first or we'll conflict with the
					// duplicate constraint
					query = "delete from songs where song_id = " + songid.ToString();
					SqlCommand deleteCmd = new SqlCommand(query, cn);
					deleteCmd.ExecuteNonQuery();

					// Update the "missing" song to be no longer missing,
					// and update the path
					query = "update songs set song_missing = 0, song_fullpath = @fullpath where song_id = " + keepId.ToString();
					SqlCommand updateCmd = new SqlCommand(query, cn);
					updateCmd.Parameters.Add("@fullpath", row["song_fullpath"]);
					updateCmd.ExecuteNonQuery();
				} else
				{
					rdr.Close();
				};
			}
#endif

			try
			{
				DataSet ds = new DataSet();

				SqlDataAdapter adapt = new SqlDataAdapter("select folder_Path from folders", cn);
				adapt.Fill(ds);

				foreach (DataRow row in ds.Tables[0].Rows)
				{
					ScanFolder((string)row["folder_Path"]);
				}
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return;
			};
		}

		public void UpdateFromTags()
		{
			// Read in the whole database (okay this may not be the best way to do this
			// but generally it's not that big, even a few thousand songs isn't that
			// much data in the grand scheme of things
			DataSet ds = new DataSet();
			SqlDataAdapter adapt = new SqlDataAdapter("select song_ID from songs where song_missing = 0", cn);
			adapt.Fill(ds);

			SqlCommand cmd = new SqlCommand();
			cmd.Connection = cn;

			// Find the row we're working on
			foreach (DataRow row in ds.Tables[0].Rows)
			{
				// Initialize the fields we're looking for to zero
				string artist = "";
				string album = "";
				int yearNumeric = 1900;
				string yearString = "";
				string title = "";

				try
				{
					string sqlText = "Update Songs Set song_Artist=@Artist, " + 
						"song_Album=@Album, song_YearNumeric=@YearNumeric, " + 
						"song_YearString=@YearString, song_Title=@Title " + 
						"where song_ID = " + row["song_ID"].ToString();

					// Get the path of the song we're working with
					cmd.CommandText = "Select song_FullPath from Songs where song_ID = " + row["song_ID"].ToString();
					string FullPath = cmd.ExecuteScalar().ToString();

					mp3info.mp3info info = new mp3info.mp3info(FullPath);
					info.ReadAll();

					if (info.hasID3v2)
					{
						if (info.id3v2.Artist != null && info.id3v2.Artist.Length > 0)
							artist = info.id3v2.Artist;

						if (info.id3v2.Album != null && info.id3v2.Album.Length > 0)
							album = info.id3v2.Album;

						if (info.id3v2.Year != null && info.id3v2.Year.Length > 0)
						{
							yearString = info.id3v2.Year;
							try
							{
								yearNumeric = Int32.Parse(yearString);
							} 
							catch (Exception)
							{
								// invalid number
								yearNumeric = 1900;
							};
						}

						if (info.id3v2.Title != null && info.id3v2.Title.Length > 0)
							title = info.id3v2.Title;
					};

					if (info.hasID3v1)
					{
						if (artist == "")
						{
							if (info.id3v1.Artist != null && info.id3v1.Artist.Length > 0)
								artist = info.id3v1.Artist;
						};

						if (album == "")
						{
							if (info.id3v1.Album != null && info.id3v1.Album.Length > 0)
								album = info.id3v1.Album;
						};

						if (yearString == "")
						{
							if (info.id3v1.Year != null && info.id3v1.Year.Length > 0)
							{
								yearString = info.id3v1.Year;

								try
								{
									yearNumeric = Int32.Parse(yearString);
								} 
								catch (Exception)
								{
									// invalid number
									yearNumeric = 1900;
								};
							}
						};

						if (title == "")
						{
							if (info.id3v1.Title != null && info.id3v1.Title.Length > 0)
								title = info.id3v1.Title;
						};
					};

					// Replace nulls with spaces, then trim spaces
					artist = artist.Replace('\0', ' ').Trim();
					album = album.Replace('\0', ' ').Trim();
					yearString = yearString.Replace('\0', ' ').Trim();
					title = title.Replace('\0', ' ').Trim();

					cmd.CommandText = sqlText;

					cmd.Parameters.Add("@Artist", artist);
					cmd.Parameters.Add("@Album", album);
					cmd.Parameters.Add("@YearNumeric", yearNumeric);
					cmd.Parameters.Add("@YearString", yearString);
					cmd.Parameters.Add("@Title", title);

					cmd.ExecuteNonQuery();
					cmd.Parameters.Clear();
				} 
				catch (Exception ex)
				{
					LogException(ex);
				};
			};
		}

		public void GetArtistsList(int UserID, FilterSet CurrentFilters, ref StringCollection artists)
		{
			SqlCommand cmd = new SqlCommand();
			cmd.Connection = cn;

			string WhereClause = CurrentFilters.GetWhereClause(cmd);
			if (WhereClause.Length > 0)
				WhereClause = "Where " + WhereClause;

			string SelectText = "Select song_Artist from Songs " +
				"LEFT OUTER JOIN TagAssoc on Songs.song_ID = TagAssoc.tagassoc_SongID " +
				"LEFT OUTER JOIN Ratings on (Songs.song_ID = Ratings.rating_SongID and Ratings.rating_UserID = " + UserID.ToString() + ") " +
				"LEFT OUTER JOIN Users on Songs.song_OwnerID = Users.user_ID " +
				"LEFT OUTER JOIN Tags on TagAssoc.tagassoc_TagID = Tags.tag_ID " + 
				WhereClause + 
				" Group by Songs.song_Artist";

			cmd.CommandText = SelectText;

			try
			{
				SqlDataReader rdr = cmd.ExecuteReader();
				while (rdr.Read())
				{
					artists.Add(rdr["song_Artist"].ToString());
				};
				rdr.Close();
			} 
			catch (Exception ex)
			{
				LogException(ex);
			};
		}

		// Populate a string list with songs with these artists
		public void BuildSongListFromArtists(StringCollection songs, IEnumerable artistList)
		{
			// Create the command
			SqlCommand cmd = new SqlCommand();
			cmd.Connection = cn;

			// Build a variable for each artist we're interested in
			int varNum = 1;
			string InStatement = "";
			foreach (string artist in artistList)
			{
				if (InStatement.Length > 0)
					InStatement += ", ";

				string varName = String.Format("@Var{0}", varNum++);
				InStatement += varName;
				cmd.Parameters.Add(varName, artist);
			};

			// Build the SQL string
			string sqlCmd = "Select song_FullPath from Songs where song_Artist in (" + InStatement + ") order by song_Artist"; // = @Artist";
			cmd.CommandText = sqlCmd;

			// Fetch the data
			DataSet ds = new DataSet();
			SqlDataAdapter adapt = new SqlDataAdapter(cmd);
			adapt.Fill(ds);

			// Copy it into the string list
			foreach (DataRow row in ds.Tables[0].Rows)
			{
				songs.Add(row[0].ToString());
			};
		}

		// Populate the main songs list
		public DataSet QuerySongList(FilterSet CurrentFilters, IEnumerable artistList, int UserID)
		{
			// Create the command
			SqlCommand cmd = new SqlCommand();
			cmd.Connection = cn;

			// Get the where clause that the filter statement represents
			string WhereClause = CurrentFilters.GetWhereClause(cmd);

			// Build a variable for each artist we're interested in
			int varNum = 1;
			string InStatement = "";
			foreach (string artist in artistList)
			{
				if (InStatement.Length > 0)
					InStatement += ", ";

				string varName = String.Format("@WhereArtistVar{0}", varNum++);
				InStatement += varName;
				cmd.Parameters.Add(varName, artist);
			};

			if (InStatement.Length > 0)
			{
				if (WhereClause.Length > 0)
				{
					WhereClause += " And ";
				};
				WhereClause += String.Format("song_Artist in ({0}) ", InStatement);
			};

			if (WhereClause.Length > 0)
				WhereClause = "Where " + WhereClause;

			string SelectText = "Select song_FullPath, song_Album, user_Name, rating_Value from Songs " +
				"LEFT OUTER JOIN TagAssoc on Songs.song_ID = TagAssoc.tagassoc_SongID " +
				"LEFT OUTER JOIN Ratings on (Songs.song_ID = Ratings.rating_SongID and Ratings.rating_UserID = " + UserID.ToString() + ") " +
				"LEFT OUTER JOIN Users on Songs.song_OwnerID = Users.user_ID " +
				"LEFT OUTER JOIN Tags on TagAssoc.tagassoc_TagID = Tags.tag_ID " + 
				WhereClause + 
				" Group by song_FullPath, song_Album, rating_Value, user_Name Order by song_FullPath";

			cmd.CommandText = SelectText;

			// Fetch the data
			DataSet ds = new DataSet();
			SqlDataAdapter adapt = new SqlDataAdapter(cmd);
			adapt.Fill(ds);

			return ds;
		}

		// Populate a string list with the single column returned
		// from a passed-in SQL query
		public bool SqlQueryStringList(StringCollection stringCollection, string sqlQuery)
		{
			try
			{
				// Fetch the data into a DataSet in one call
				DataSet ds = new DataSet();
				SqlDataAdapter adapt = new SqlDataAdapter(sqlQuery, cn);
				adapt.Fill(ds);

				// Copy it into the string list
				foreach (DataRow row in ds.Tables[0].Rows)
				{
					stringCollection.Add(row[0].ToString());
				}

				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public int GetUserID(string UserName)
		{
			try
			{
				// Find the ID of the new owner
				SqlCommand cmd = new SqlCommand("select user_ID from Users where user_Name = @Name", cn);
				cmd.Parameters.Add("@Name", UserName);
				return (int)cmd.ExecuteScalar();
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return 0;
			};
		}

		public int GetTagID(string TagName)
		{
			try
			{
				// Find the ID of the new owner
				SqlCommand cmd = new SqlCommand("select tag_ID from Tags where tag_Name = @TagName", cn);
				cmd.Parameters.Add("@TagName", TagName);
				return (int)cmd.ExecuteScalar();
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return 0;
			};
		}

		public int GetSongID(string FullPath)
		{
			try
			{
				// Find the ID of the new owner
				SqlCommand cmd = new SqlCommand("select song_ID from Songs where song_FullPath = @FullPath", cn);
				cmd.Parameters.Add("@FullPath", FullPath);
				return (int)cmd.ExecuteScalar();
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return 0;
			};
		}

		public int GetPlaylistID(int OwnerID, string PlaylistName)
		{
			try
			{
				// Find the ID of the new owner
				SqlCommand cmd = new SqlCommand("select playlist_ID from Playlists where playlist_Name = @PlaylistName and playlist_OwnerID = @OwnerID ", cn);
				cmd.Parameters.Add("@PlaylistName", PlaylistName);
				cmd.Parameters.Add("@OwnerID", OwnerID);
				return (int)cmd.ExecuteScalar();
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return 0;
			};
		}

		public bool SetSongOwner(string FullPath, int OwnerID)
		{
			SqlCommand cmd = new SqlCommand("update songs set song_OwnerID = @OwnerID where song_FullPath = @FullPath", cn);
			cmd.Parameters.Add("@OwnerID", OwnerID);
			cmd.Parameters.Add("@FullPath", FullPath);
			cmd.ExecuteNonQuery();

			return true;
		}

		public bool SetSongRating(string FullPath, int UserID, int Rating)
		{
			int SongID = GetSongID(FullPath);
			if (SongID == 0)
				return false;

			try
			{
				// Try to update an existing rating
				SqlCommand cmd = new SqlCommand("update Ratings set rating_Value = @Rating where rating_SongID = @SongID and rating_UserID = @UserID", cn);
				cmd.Parameters.Add("@SongID", SongID);
				cmd.Parameters.Add("@Rating", Rating);
				cmd.Parameters.Add("@UserID", UserID);
				if (cmd.ExecuteNonQuery() == 0)
				{
					// No rows affected; add a new one
					cmd.CommandText = "insert into Ratings (rating_SongID, rating_Value, rating_UserID) values (@SongID, @Rating, @UserID)";
					cmd.ExecuteNonQuery();
				};

				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}	

		public StringCollection GetUsersList()
		{
			StringCollection coll = new StringCollection();
			string SqlQuery = "Select user_Name from Users order by user_Name";

			// Either return the collection or return NULL
			if (SqlQueryStringList(coll, SqlQuery))
			{
				return coll;
			} 
			else
			{
				return null;
			};
		}

		public bool CheckSongTag(int SongID, int TagID)
		{
			try
			{
				// Find the ID of the new owner
				SqlCommand cmd = new SqlCommand("select tagassoc_ID from TagAssoc where tagassoc_SongID = @SongID and tagassoc_TagID = @TagID", cn);
				cmd.Parameters.Add("@SongID", SongID);
				cmd.Parameters.Add("@TagID", TagID);
				return cmd.ExecuteScalar() != null;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public bool SetTag(int SongID, int TagID)
		{
			try
			{
				// Find the ID of the new owner
				SqlCommand cmd = new SqlCommand("select count(tagassoc_SongID) from tagassoc where tagassoc_SongID = @SongID and tagassoc_TagID = @TagID", cn);
				cmd.Parameters.Add("@SongID", SongID);
				cmd.Parameters.Add("@TagID", TagID);
				if ((int)cmd.ExecuteScalar() == 0)
				{
					cmd.CommandText = "insert into tagassoc (tagassoc_SongID, tagassoc_TagID) values (@SongID, @TagID)";
					cmd.ExecuteNonQuery();
				};
				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public bool RemoveTag(int SongID, int TagID)
		{
			try
			{
				// Find the ID of the new owner
				SqlCommand cmd = new SqlCommand("delete from tagassoc where tagassoc_SongID = @SongID and tagassoc_TagID = @TagID", cn);
				cmd.Parameters.Add("@SongID", SongID);
				cmd.Parameters.Add("@TagID", TagID);
				cmd.ExecuteNonQuery();
				return true;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return false;
			};
		}

		public DataSet SqlQueryDataSet(string SqlQuery)
		{
			try
			{
				DataSet ds = new DataSet();
				SqlDataAdapter adapt = new SqlDataAdapter(SqlQuery, cn);
				adapt.Fill(ds);
				return ds;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return null;
			};
		}

		public DataSet GetTagCountsForSongList(StringCollection songCollection)
		{
			try
			{
				string VarList = "";
				int varCount = 1;

				SqlCommand cmd = new SqlCommand();
				cmd.Connection = cn;

				// Build the variable list and add the song names to the parameters collection
				foreach (string song in songCollection)
				{
					if (VarList != "")
						VarList += ", ";

					string varName = String.Format("@Var{0}", varCount++);
					VarList += varName;
					cmd.Parameters.Add(varName, song);
				};

				// No songs?
				if (VarList.Length == 0)
				{
					return null;
				};

				string SqlText = "SELECT COUNT(Songs.song_Filename) AS TagCount, dbo.Tags.tag_Name As TagName " +
					"FROM Songs INNER JOIN " + 
					"TagAssoc ON Songs.song_ID = TagAssoc.tagassoc_SongID RIGHT OUTER JOIN " +
					"Tags ON TagAssoc.tagassoc_TagID = Tags.tag_ID " +
					"WHERE (dbo.Songs.song_FullPath IN (" + VarList + ")) " +
					"GROUP BY dbo.Tags.tag_Name";

				cmd.CommandText = SqlText;
				
				SqlDataAdapter adapt = new SqlDataAdapter(cmd);
				DataSet ds = new DataSet();
				adapt.Fill(ds);
				return ds;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return null;
			};
		}

		// Log the fact that this user listened to this song
		[OneWayAttribute]
		public void LogListen(int UserID, string FullPath)
		{
			LogListen(UserID, GetSongID(FullPath));
		}

		[OneWayAttribute]
		public void LogListen(int UserID, int SongID)
		{
			try
			{
				// Try to update an existing rating
				SqlCommand cmd = new SqlCommand("update Listen set listen_Count = listen_Count + 1, listen_Date = @Now where listen_SongID = @SongID and listen_UserID = @UserID", cn);
				cmd.Parameters.Add("@Now", System.DateTime.Now);
				cmd.Parameters.Add("@SongID", SongID);
				cmd.Parameters.Add("@UserID", UserID);
				if (cmd.ExecuteNonQuery() == 0)
				{
					// No rows affected; add a new one
					cmd.CommandText = "insert into Listen (listen_SongID, listen_Date, listen_Count, listen_UserID) values (@SongID, @Now, 1, @UserID)";
					cmd.ExecuteNonQuery();
				};

				return;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return;
			};
		}

		public void VerifyFiles()
		{
			// TODO: Add some way for this function to inform 
			// the user of it's progress

			try
			{
				// Try to update an existing rating
				DataSet ds = new DataSet();
				SqlDataAdapter adapt = new SqlDataAdapter("select song_ID, song_FullPath from songs where song_Missing = 0", cn);
				adapt.Fill(ds);
				SqlCommand cmd = new SqlCommand();
				cmd.Connection = cn;

				foreach (DataRow row in ds.Tables[0].Rows)
				{
					string FullPath = (string)row["song_FullPath"];
					bool FileExists = false;

					try
					{
						if (System.IO.File.Exists(FullPath))
						{
							// Cool, we found it
							FileExists = true;
						};
					} 
					catch (Exception)
					{
						// An exception is the same as if we didn't
						// find the file
					};

					if (!FileExists)
					{
						cmd.CommandText = "update songs set song_Missing = 1 where song_ID = " + row["song_ID"].ToString();
						cmd.ExecuteNonQuery();
					};
				}

				return;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return;
			};
		}

		/// <summary>
		///  Permanently delete a song from the database; removes
		///  all associated tags, removes it from playlists, etc.
		///  Use this very sparingly!  If a song is missing, then flag
		///  it as missing instead of removing it; that way if it returns,
		///  the tags will return as well.
		/// </summary>
		private void RemoveSongFromDatabase(int SongID)
		{
			SqlCommand cmd = new SqlCommand();
			cmd.Connection = cn;

			// Remove the song itself
			string SqlString = "DELETE from Songs where song_ID = " + SongID.ToString();
			cmd.CommandText = SqlString;
			cmd.ExecuteNonQuery();

			// Remove the tags
			SqlString = "DELETE from TagAssoc where tagassoc_SongID = " + SongID.ToString();
			cmd.CommandText = SqlString;
			cmd.ExecuteNonQuery();

			// Remove any ratings
			SqlString = "DELETE from Ratings where rating_SongID = " + SongID.ToString();
			cmd.CommandText = SqlString;
			cmd.ExecuteNonQuery();

			// Remove it from any playlists
			SqlString = "DELETE from PlayListEntries where playlistentry_SongID = " + SongID.ToString();
			cmd.CommandText = SqlString;
			cmd.ExecuteNonQuery();
		}

		// Permanently delete all songs tagged 'Crap'
		public void DeleteCrap()
		{
			// TODO: Add some way for this function to inform 
			// the user of it's progress

			int CrapTagID = GetTagID("To Be Deleted");
			if (CrapTagID == 0)
				return;

			try
			{
				// Try to update an existing rating
				DataSet ds = new DataSet();

				string SqlString = String.Format(
						"SELECT song_ID, Songs.song_FullPath FROM Songs " +
						"INNER JOIN TagAssoc ON Songs.song_ID = TagAssoc.tagassoc_SongID " +
						"WHERE (TagAssoc.tagassoc_TagID = {0})", CrapTagID);

				// Get the list of songs to delete
				SqlDataAdapter adapt = new SqlDataAdapter(SqlString, cn);
				adapt.Fill(ds);
				SqlCommand cmd = new SqlCommand();
				cmd.Connection = cn;

				foreach (DataRow row in ds.Tables[0].Rows)
				{
					string FullPath = (string)row["song_FullPath"];
					int SongID = (int)row["song_ID"];

					try
					{
						if (System.IO.File.Exists(FullPath))
						{
							System.IO.File.Delete(FullPath);
						}

						RemoveSongFromDatabase(SongID);
					} 
					catch (Exception ex)
					{
						// Doh
						LogException(ex);
					};
				}

				return;
			} 
			catch (Exception ex)
			{
				LogException(ex);
				return;
			};
		}
	}
}
