using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Runtime.Serialization.Formatters;
using MarcObjects;
using System.Configuration.Install;

namespace MarcDbService
{
	[RunInstallerAttribute(true)]
	public class PS_ServiceInstall : Installer
	{
		ServiceInstaller m_ServiceInstaller;
		ServiceProcessInstaller m_ProcessInstaller;

		public PS_ServiceInstall()
		{
			string[] depends = { "MSSQL$VSdotNET2003" };
			this.m_ServiceInstaller = new ServiceInstaller();
			this.m_ServiceInstaller.StartType = ServiceStartMode.Automatic;
			this.m_ServiceInstaller.ServiceName = "MarcDbService";
			this.m_ServiceInstaller.DisplayName = "Marc Music Library Database Service";
			this.m_ServiceInstaller.ServicesDependedOn = depends;
			Installers.Add (this.m_ServiceInstaller);
 
			this.m_ProcessInstaller = new ServiceProcessInstaller ();
			this.m_ProcessInstaller.Account = System.ServiceProcess.ServiceAccount.LocalSystem;
			Installers.Add (this.m_ProcessInstaller);
		}
	};

	public class MarcDbService : System.ServiceProcess.ServiceBase
	{
		private ServiceCore Core;
		private ObjRef or;
		private TcpChannel channel;

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private System.Timers.Timer PingTimer;

		public MarcDbService()
		{
			// This call is required by the Windows.Forms Component Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitComponent call
		}

		// The main entry point for the process
		static void Main()
		{
			System.ServiceProcess.ServiceBase[] ServicesToRun;
	
			// More than one user Service may run within the same process. To add
			// another service to this process, change the following line to
			// create a second service object. For example,
			//
			//   ServicesToRun = new System.ServiceProcess.ServiceBase[] {new MarcDbService(), new MySecondUserService()};
			//
			ServicesToRun = new System.ServiceProcess.ServiceBase[] { new MarcDbService() };

			System.ServiceProcess.ServiceBase.Run(ServicesToRun);
		}

		private void PingTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			Core.PingPlayers();
		}

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			this.ServiceName = "MarcDbService";
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Set things in motion so your service can do its work.
		/// </summary>
		protected override void OnStart(string[] args)
		{
			try
			{
				BinaryServerFormatterSinkProvider provider = new BinaryServerFormatterSinkProvider();
				provider.TypeFilterLevel = TypeFilterLevel.Full;

				Hashtable ht = new Hashtable();
				ht.Add("port", 9933);

				channel = new TcpChannel(ht, null, provider);
				ChannelServices.RegisterChannel( channel );

				// Create and register the office
				Core = new ServiceCore(); 
				Core.EventLog = EventLog;
				or = RemotingServices.Marshal(Core, "ServiceCore");

				this.PingTimer = new System.Timers.Timer();

				((System.ComponentModel.ISupportInitialize)(this.PingTimer)).BeginInit();
				this.PingTimer.Enabled = true;
				this.PingTimer.Interval = 180000;
				this.PingTimer.Elapsed += new System.Timers.ElapsedEventHandler(this.PingTimer_Elapsed);
				((System.ComponentModel.ISupportInitialize)(this.PingTimer)).EndInit();
			} 
			catch (Exception)
			{
				EventLog.WriteEntry("Unable to bind to port 9933");
				throw;
			};
		}

		/// <summary>
		/// Stop this service.
		/// </summary>
		protected override void OnStop()
		{
			this.PingTimer.Stop();
			this.PingTimer = null;

			RemotingServices.Unmarshal(or);
			Core = null;

			ChannelServices.UnregisterChannel(channel);
			channel = null;
		}
	}
}
