using System;
using System.Drawing;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Windows.Forms;
using MarcObjects;

namespace Marc
{
	/// <summary>
	/// Summary description for PlaylistsForm.
	/// </summary>
	public class PlaylistsForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListBox PlaylistListBox;
		private System.Windows.Forms.Label YourPlaylistsLabel;
		private System.Windows.Forms.Button CloseButton;
		private System.Windows.Forms.Button DeletePlaylistsButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		MusicLibrary MusicLib;
		int CurrentUserID;

		public PlaylistsForm(MusicLibrary MusicLib, int CurrentUserID)
		{
			this.CurrentUserID = CurrentUserID;
			this.MusicLib = MusicLib;

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.PlaylistListBox = new System.Windows.Forms.ListBox();
			this.YourPlaylistsLabel = new System.Windows.Forms.Label();
			this.CloseButton = new System.Windows.Forms.Button();
			this.DeletePlaylistsButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// PlaylistListBox
			// 
			this.PlaylistListBox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.PlaylistListBox.Location = new System.Drawing.Point(8, 24);
			this.PlaylistListBox.Name = "PlaylistListBox";
			this.PlaylistListBox.SelectionMode = System.Windows.Forms.SelectionMode.MultiExtended;
			this.PlaylistListBox.Size = new System.Drawing.Size(272, 212);
			this.PlaylistListBox.TabIndex = 0;
			this.PlaylistListBox.SelectedIndexChanged += new System.EventHandler(this.PlaylistListBox_SelectedIndexChanged);
			// 
			// YourPlaylistsLabel
			// 
			this.YourPlaylistsLabel.Location = new System.Drawing.Point(8, 8);
			this.YourPlaylistsLabel.Name = "YourPlaylistsLabel";
			this.YourPlaylistsLabel.Size = new System.Drawing.Size(100, 16);
			this.YourPlaylistsLabel.TabIndex = 1;
			this.YourPlaylistsLabel.Text = "Your Playlists:";
			// 
			// CloseButton
			// 
			this.CloseButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.CloseButton.Location = new System.Drawing.Point(208, 240);
			this.CloseButton.Name = "CloseButton";
			this.CloseButton.TabIndex = 2;
			this.CloseButton.Text = "&Close";
			this.CloseButton.Click += new System.EventHandler(this.CloseButton_Click);
			// 
			// DeletePlaylistsButton
			// 
			this.DeletePlaylistsButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.DeletePlaylistsButton.Enabled = false;
			this.DeletePlaylistsButton.Location = new System.Drawing.Point(8, 240);
			this.DeletePlaylistsButton.Name = "DeletePlaylistsButton";
			this.DeletePlaylistsButton.Size = new System.Drawing.Size(192, 23);
			this.DeletePlaylistsButton.TabIndex = 3;
			this.DeletePlaylistsButton.Text = "&Delete Selected Playlists";
			this.DeletePlaylistsButton.Click += new System.EventHandler(this.DeletePlaylistsButton_Click);
			// 
			// PlaylistsForm
			// 
			this.AcceptButton = this.CloseButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 270);
			this.Controls.Add(this.DeletePlaylistsButton);
			this.Controls.Add(this.CloseButton);
			this.Controls.Add(this.YourPlaylistsLabel);
			this.Controls.Add(this.PlaylistListBox);
			this.Name = "PlaylistsForm";
			this.Text = "Playlist Manager";
			this.Load += new System.EventHandler(this.PlaylistsForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void CloseButton_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		private void PlaylistsForm_Load(object sender, System.EventArgs e)
		{
			Populate();
		}

		private void PlaylistListBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			DeletePlaylistsButton.Enabled = true;
		}

		private void DeletePlaylistsButton_Click(object sender, System.EventArgs e)
		{
			foreach (string playlist in PlaylistListBox.SelectedItems)
			{
				MusicLib.DeletePlaylist(CurrentUserID, playlist);
			}

			Populate();
		}

		void Populate()
		{
			// Clear the current items
			PlaylistListBox.Items.Clear();

			// And populate it
			StringCollection playlist = MusicLib.GetPlaylistList(CurrentUserID);
			foreach (string str in playlist)
			{
				PlaylistListBox.Items.Add(str);
			}
		}
	}
}
