using System;
using System.Collections;
using System.Collections.Specialized;

namespace Marc
{
	/// <summary>
	/// Summary description for MusicFolder.
	/// </summary>
	public class MusicFolder
	{
		public string BasePath;

		void Recurse(StringCollection Paths, string RelativePath)
		{
			string FinalPath = BasePath + RelativePath;
			string[] Files = System.IO.Directory.GetFiles(FinalPath, "*.mp3");
			foreach (string FileName in Files)
			{
				Paths.Add(RelativePath + FileName);
			};

			string[] Dirs = System.IO.Directory.GetDirectories(FinalPath);
			foreach (string DirName in Files)
			{
				FinalPath = BasePath + DirName + "\\";
				Recurse(Paths, FinalPath);
			};
		}

		public StringCollection GetFilePaths()
		{
			StringCollection paths = new StringCollection();

			Recurse(paths, "");

			return paths;
		}

		public MusicFolder(string BasePath)
		{
			if (!BasePath.EndsWith("\\"))
				BasePath += "\\";

			this.BasePath = BasePath;
		}
	}
}
