using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using MarcObjects;

namespace Marc
{
	/// <summary>
	/// Summary description for ManageForm.
	/// </summary>
	public class ManageForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button LibraryManagementButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button ScanAllFoldersButton;
		private System.Windows.Forms.Button UpdateFromId3TagsButton;
		private System.Windows.Forms.Button ManagePlaylistsButton;

		public MusicLibrary MusicLib;
		private System.Windows.Forms.Button VerifyFilesButton;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Button DeleteCrapButton;
		private System.Windows.Forms.Button AddSongsButton;
		int CurrentUserID;

		public ManageForm(MusicLibrary MusicLib, int CurrentUserID)
		{
			this.CurrentUserID = CurrentUserID;
			this.MusicLib = MusicLib;

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.LibraryManagementButton = new System.Windows.Forms.Button();
			this.ScanAllFoldersButton = new System.Windows.Forms.Button();
			this.UpdateFromId3TagsButton = new System.Windows.Forms.Button();
			this.AddSongsButton = new System.Windows.Forms.Button();
			this.ManagePlaylistsButton = new System.Windows.Forms.Button();
			this.VerifyFilesButton = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.DeleteCrapButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// LibraryManagementButton
			// 
			this.LibraryManagementButton.Location = new System.Drawing.Point(24, 176);
			this.LibraryManagementButton.Name = "LibraryManagementButton";
			this.LibraryManagementButton.Size = new System.Drawing.Size(168, 23);
			this.LibraryManagementButton.TabIndex = 0;
			this.LibraryManagementButton.Text = "Library Management";
			this.LibraryManagementButton.Click += new System.EventHandler(this.LibraryManagementButton_Click);
			// 
			// ScanAllFoldersButton
			// 
			this.ScanAllFoldersButton.Location = new System.Drawing.Point(24, 80);
			this.ScanAllFoldersButton.Name = "ScanAllFoldersButton";
			this.ScanAllFoldersButton.Size = new System.Drawing.Size(168, 23);
			this.ScanAllFoldersButton.TabIndex = 1;
			this.ScanAllFoldersButton.Text = "Scan All Folders";
			this.ScanAllFoldersButton.Click += new System.EventHandler(this.button1_Click_1);
			// 
			// UpdateFromId3TagsButton
			// 
			this.UpdateFromId3TagsButton.Location = new System.Drawing.Point(24, 112);
			this.UpdateFromId3TagsButton.Name = "UpdateFromId3TagsButton";
			this.UpdateFromId3TagsButton.Size = new System.Drawing.Size(168, 23);
			this.UpdateFromId3TagsButton.TabIndex = 2;
			this.UpdateFromId3TagsButton.Text = "Update from ID3 tags";
			this.UpdateFromId3TagsButton.Click += new System.EventHandler(this.UpdateFromId3TagsButton_Click);
			// 
			// AddSongsButton
			// 
			this.AddSongsButton.Location = new System.Drawing.Point(24, 16);
			this.AddSongsButton.Name = "AddSongsButton";
			this.AddSongsButton.Size = new System.Drawing.Size(168, 23);
			this.AddSongsButton.TabIndex = 3;
			this.AddSongsButton.Text = "Add Songs...";
			this.AddSongsButton.Click += new System.EventHandler(this.AddSongsButton_Click);
			// 
			// ManagePlaylistsButton
			// 
			this.ManagePlaylistsButton.Location = new System.Drawing.Point(24, 48);
			this.ManagePlaylistsButton.Name = "ManagePlaylistsButton";
			this.ManagePlaylistsButton.Size = new System.Drawing.Size(168, 23);
			this.ManagePlaylistsButton.TabIndex = 4;
			this.ManagePlaylistsButton.Text = "Manage Playlists";
			this.ManagePlaylistsButton.Click += new System.EventHandler(this.ManagePlaylistsButton_Click);
			// 
			// VerifyFilesButton
			// 
			this.VerifyFilesButton.Location = new System.Drawing.Point(24, 144);
			this.VerifyFilesButton.Name = "VerifyFilesButton";
			this.VerifyFilesButton.Size = new System.Drawing.Size(168, 23);
			this.VerifyFilesButton.TabIndex = 5;
			this.VerifyFilesButton.Text = "Verify Files Exist";
			this.VerifyFilesButton.Click += new System.EventHandler(this.VerifyFilesButton_Click);
			// 
			// label1
			// 
			this.label1.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.label1.Location = new System.Drawing.Point(208, 176);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(224, 23);
			this.label1.TabIndex = 6;
			this.label1.Text = "Physical locations of files.";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label2
			// 
			this.label2.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.label2.Location = new System.Drawing.Point(208, 144);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(288, 23);
			this.label2.TabIndex = 7;
			this.label2.Text = "Verifies all files still exist; marks missing files as missing.";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label3
			// 
			this.label3.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.label3.Location = new System.Drawing.Point(208, 112);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(288, 23);
			this.label3.TabIndex = 8;
			this.label3.Text = "Adds song info to the database from ID3 tags.";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label4
			// 
			this.label4.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.label4.Location = new System.Drawing.Point(208, 80);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(296, 23);
			this.label4.TabIndex = 9;
			this.label4.Text = "Scan all folders, make sure all songs are in the database.";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label5
			// 
			this.label5.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.label5.Location = new System.Drawing.Point(208, 48);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(296, 23);
			this.label5.TabIndex = 10;
			this.label5.Text = "Delete playlists.";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label6
			// 
			this.label6.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.label6.Location = new System.Drawing.Point(208, 16);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(296, 23);
			this.label6.TabIndex = 11;
			this.label6.Text = "Add individual songs to the database.";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label7
			// 
			this.label7.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.label7.Location = new System.Drawing.Point(208, 208);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(288, 23);
			this.label7.TabIndex = 13;
			this.label7.Text = "Permanently delete all songs tagged \'To Be Deleted\'.";
			this.label7.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DeleteCrapButton
			// 
			this.DeleteCrapButton.Location = new System.Drawing.Point(24, 208);
			this.DeleteCrapButton.Name = "DeleteCrapButton";
			this.DeleteCrapButton.Size = new System.Drawing.Size(168, 23);
			this.DeleteCrapButton.TabIndex = 12;
			this.DeleteCrapButton.Text = "Delete \'To Be Deleted\' Files";
			this.DeleteCrapButton.Click += new System.EventHandler(this.DeleteCrapButton_Click);
			// 
			// ManageForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(536, 246);
			this.Controls.Add(this.label7);
			this.Controls.Add(this.DeleteCrapButton);
			this.Controls.Add(this.label6);
			this.Controls.Add(this.label5);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.VerifyFilesButton);
			this.Controls.Add(this.ManagePlaylistsButton);
			this.Controls.Add(this.AddSongsButton);
			this.Controls.Add(this.UpdateFromId3TagsButton);
			this.Controls.Add(this.ScanAllFoldersButton);
			this.Controls.Add(this.LibraryManagementButton);
			this.Name = "ManageForm";
			this.Text = "Music Library Management";
			this.ResumeLayout(false);

		}
		#endregion

		private void LibraryManagementButton_Click(object sender, System.EventArgs e)
		{
			LibraryForm libraryForm = new LibraryForm(MusicLib);
			DialogResult dr = libraryForm.ShowDialog(this);
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
		}

		private void button1_Click_1(object sender, System.EventArgs e)
		{
			MusicLib.ScanAllFolders();
		}

		private void UpdateFromId3TagsButton_Click(object sender, System.EventArgs e)
		{
			MusicLib.UpdateFromTags();
		}

		private void AddSongsButton_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show("Not implemented yet.");
		}

		private void ManagePlaylistsButton_Click(object sender, System.EventArgs e)
		{
			PlaylistsForm form = new PlaylistsForm(MusicLib, CurrentUserID);
			form.ShowDialog(this);
		}

		private void VerifyFilesButton_Click(object sender, System.EventArgs e)
		{
			MusicLib.VerifyFiles();
		}

		private void DeleteCrapButton_Click(object sender, System.EventArgs e)
		{
			MusicLib.DeleteCrap();
		}
	}
}
