using System;
using System.Runtime.Remoting.Services;
using System.Runtime.Remoting.Lifetime;
using MarcObjects;

namespace Marc
{
	/// <summary>
	/// Summary description for LibraryPlayerClient.
	/// </summary>
	public class LibraryPlayerClient : PlayerClient
	{
		Browser PlayerForm;

		public LibraryPlayerClient(Browser PlayerForm, string Name, ServiceCore Core) : base(Core)
		{
			this.Name = Name;
			this.PlayerForm = PlayerForm;
		}

		public override void PlaySong(string FullPath)
		{
			object[] Args = { FullPath };
			PlayerForm.Invoke(new Browser.PlaySongDelegate(PlayerForm.Player_PlaySong), Args);
		}

		public override void Control(string Message, string Argument)
		{
			object[] Args = { Message, Argument };
			PlayerForm.Invoke(new Browser.PlayerConrolDelegate(PlayerForm.Player_Control), Args);
		}

		public override Object InitializeLifetimeService()
		{
			ILease lease = (ILease)base.InitializeLifetimeService();
			lease.InitialLeaseTime = TimeSpan.FromMinutes(60);
			return lease;
		}	
	}
}
