using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Marc
{
	/// <summary>
	/// Summary description for LibraryForm.
	/// </summary>
	public class LibraryForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListView FolderListView;
		private System.Windows.Forms.Label MusicFoldersLabel;
		private System.Windows.Forms.Button AddFolderButton;
		private System.Windows.Forms.Button RemoveFolderButton;
		private System.Windows.Forms.Button CloseButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		MarcObjects.MusicLibrary MusicLib;

		public LibraryForm(MarcObjects.MusicLibrary lib)
		{
			this.MusicLib = lib;

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.FolderListView = new System.Windows.Forms.ListView();
			this.MusicFoldersLabel = new System.Windows.Forms.Label();
			this.AddFolderButton = new System.Windows.Forms.Button();
			this.RemoveFolderButton = new System.Windows.Forms.Button();
			this.CloseButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// FolderListView
			// 
			this.FolderListView.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.FolderListView.Location = new System.Drawing.Point(16, 32);
			this.FolderListView.Name = "FolderListView";
			this.FolderListView.Size = new System.Drawing.Size(376, 192);
			this.FolderListView.TabIndex = 0;
			this.FolderListView.View = System.Windows.Forms.View.Details;
			// 
			// MusicFoldersLabel
			// 
			this.MusicFoldersLabel.Location = new System.Drawing.Point(16, 16);
			this.MusicFoldersLabel.Name = "MusicFoldersLabel";
			this.MusicFoldersLabel.Size = new System.Drawing.Size(192, 16);
			this.MusicFoldersLabel.TabIndex = 1;
			this.MusicFoldersLabel.Text = "Music Folders:";
			// 
			// AddFolderButton
			// 
			this.AddFolderButton.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.AddFolderButton.Location = new System.Drawing.Point(128, 232);
			this.AddFolderButton.Name = "AddFolderButton";
			this.AddFolderButton.Size = new System.Drawing.Size(80, 23);
			this.AddFolderButton.TabIndex = 2;
			this.AddFolderButton.Text = "&Add Folder...";
			this.AddFolderButton.Click += new System.EventHandler(this.AddFolderButton_Click);
			// 
			// RemoveFolderButton
			// 
			this.RemoveFolderButton.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.RemoveFolderButton.Enabled = false;
			this.RemoveFolderButton.Location = new System.Drawing.Point(216, 232);
			this.RemoveFolderButton.Name = "RemoveFolderButton";
			this.RemoveFolderButton.Size = new System.Drawing.Size(96, 23);
			this.RemoveFolderButton.TabIndex = 3;
			this.RemoveFolderButton.Text = "&Remove Folder";
			// 
			// CloseButton
			// 
			this.CloseButton.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.CloseButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.CloseButton.Location = new System.Drawing.Point(320, 232);
			this.CloseButton.Name = "CloseButton";
			this.CloseButton.Size = new System.Drawing.Size(72, 23);
			this.CloseButton.TabIndex = 4;
			this.CloseButton.Text = "&Close";
			// 
			// LibraryForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(408, 266);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.CloseButton,
																		  this.RemoveFolderButton,
																		  this.AddFolderButton,
																		  this.MusicFoldersLabel,
																		  this.FolderListView});
			this.Name = "LibraryForm";
			this.Text = "Library Management";
			this.Load += new System.EventHandler(this.LibraryForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void AddFolderButton_Click(object sender, System.EventArgs e)
		{
			StringRequestForm sform = new StringRequestForm();
			sform.Text = "Add Folder";
			sform.StringLabel.Text = "Folder name to add:";
			if (sform.ShowDialog(this) == DialogResult.OK)
			{
				if (System.IO.Directory.Exists(sform.StringTextBox.Text))
				{
					MusicLib.AddFolder(sform.StringTextBox.Text);
					PopulateSourcesList();
				};
			};
		}

		public void PopulateSourcesList()
		{
			FolderListView.Items.Clear();

			string[] sources = MusicLib.GetFolderList();
			foreach (string Folder in sources)
			{
				ListViewItem item = FolderListView.Items.Add(Folder);
			};

			FolderListView.Columns.Add("Path", 100, HorizontalAlignment.Left);
		}

		private void LibraryForm_Load(object sender, System.EventArgs e)
		{
			PopulateSourcesList();
		}
	}
}
