using System;
using System.Drawing;
using System.Data;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Windows.Forms;
using MarcObjects;

namespace Marc
{
	/// <summary>
	/// Summary description for FilterForm.
	/// </summary>
	public class FilterForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.GroupBox IncludeGroupBox;
		private System.Windows.Forms.CheckedListBox IncludeTagsList;
		private System.Windows.Forms.Label IncludeOwnerLabel;
		private System.Windows.Forms.Label IncludeTagsLabel;
		private System.Windows.Forms.Label IncludeRatingLabel;
		private System.Windows.Forms.GroupBox ExcludeGroupBox;
		private System.Windows.Forms.Button ResetButton;
		private System.Windows.Forms.Button CloseButton;
		private System.Windows.Forms.CheckedListBox ExcludeRatingsList;
		private System.Windows.Forms.Label ExcludeTagsLabel;
		private System.Windows.Forms.Label ExcludeOwnersLabel;
		private System.Windows.Forms.CheckedListBox ExcludeTagsList;
		private System.Windows.Forms.Label ExcludeRatingsLabel;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		Browser BrowserWindow;
		private System.Windows.Forms.CheckedListBox IncludeOwnersList;
		MarcObjects.MusicLibrary MusicLib;
		private System.Windows.Forms.CheckedListBox ExcludeOwnersList;
		private System.Windows.Forms.CheckedListBox IncludeRatingsList;
		private System.Windows.Forms.Button ApplyButton;
		MarcObjects.FilterSet Filters;

		public FilterForm(Browser parent)
		{
			BrowserWindow = parent;
			MusicLib = BrowserWindow.MusicLib;
			Filters = BrowserWindow.CurrentFilters;

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.IncludeGroupBox = new System.Windows.Forms.GroupBox();
			this.IncludeRatingsList = new System.Windows.Forms.CheckedListBox();
			this.IncludeTagsLabel = new System.Windows.Forms.Label();
			this.IncludeOwnerLabel = new System.Windows.Forms.Label();
			this.IncludeOwnersList = new System.Windows.Forms.CheckedListBox();
			this.IncludeTagsList = new System.Windows.Forms.CheckedListBox();
			this.IncludeRatingLabel = new System.Windows.Forms.Label();
			this.ExcludeGroupBox = new System.Windows.Forms.GroupBox();
			this.ExcludeRatingsList = new System.Windows.Forms.CheckedListBox();
			this.ExcludeTagsLabel = new System.Windows.Forms.Label();
			this.ExcludeOwnersLabel = new System.Windows.Forms.Label();
			this.ExcludeOwnersList = new System.Windows.Forms.CheckedListBox();
			this.ExcludeTagsList = new System.Windows.Forms.CheckedListBox();
			this.ExcludeRatingsLabel = new System.Windows.Forms.Label();
			this.ResetButton = new System.Windows.Forms.Button();
			this.CloseButton = new System.Windows.Forms.Button();
			this.ApplyButton = new System.Windows.Forms.Button();
			this.IncludeGroupBox.SuspendLayout();
			this.ExcludeGroupBox.SuspendLayout();
			this.SuspendLayout();
			// 
			// IncludeGroupBox
			// 
			this.IncludeGroupBox.Controls.Add(this.IncludeRatingsList);
			this.IncludeGroupBox.Controls.Add(this.IncludeTagsLabel);
			this.IncludeGroupBox.Controls.Add(this.IncludeOwnerLabel);
			this.IncludeGroupBox.Controls.Add(this.IncludeOwnersList);
			this.IncludeGroupBox.Controls.Add(this.IncludeTagsList);
			this.IncludeGroupBox.Controls.Add(this.IncludeRatingLabel);
			this.IncludeGroupBox.Location = new System.Drawing.Point(8, 8);
			this.IncludeGroupBox.Name = "IncludeGroupBox";
			this.IncludeGroupBox.Size = new System.Drawing.Size(304, 264);
			this.IncludeGroupBox.TabIndex = 0;
			this.IncludeGroupBox.TabStop = false;
			this.IncludeGroupBox.Text = "Include";
			// 
			// IncludeRatingsList
			// 
			this.IncludeRatingsList.CheckOnClick = true;
			this.IncludeRatingsList.Location = new System.Drawing.Point(168, 112);
			this.IncludeRatingsList.Name = "IncludeRatingsList";
			this.IncludeRatingsList.Size = new System.Drawing.Size(120, 139);
			this.IncludeRatingsList.TabIndex = 4;
			// 
			// IncludeTagsLabel
			// 
			this.IncludeTagsLabel.Location = new System.Drawing.Point(16, 24);
			this.IncludeTagsLabel.Name = "IncludeTagsLabel";
			this.IncludeTagsLabel.Size = new System.Drawing.Size(136, 16);
			this.IncludeTagsLabel.TabIndex = 3;
			this.IncludeTagsLabel.Text = "Include Tags:";
			// 
			// IncludeOwnerLabel
			// 
			this.IncludeOwnerLabel.Location = new System.Drawing.Point(168, 24);
			this.IncludeOwnerLabel.Name = "IncludeOwnerLabel";
			this.IncludeOwnerLabel.Size = new System.Drawing.Size(100, 16);
			this.IncludeOwnerLabel.TabIndex = 2;
			this.IncludeOwnerLabel.Text = "Owner:";
			// 
			// IncludeOwnersList
			// 
			this.IncludeOwnersList.CheckOnClick = true;
			this.IncludeOwnersList.Location = new System.Drawing.Point(168, 40);
			this.IncludeOwnersList.Name = "IncludeOwnersList";
			this.IncludeOwnersList.Size = new System.Drawing.Size(120, 49);
			this.IncludeOwnersList.TabIndex = 1;
			// 
			// IncludeTagsList
			// 
			this.IncludeTagsList.CheckOnClick = true;
			this.IncludeTagsList.Location = new System.Drawing.Point(16, 40);
			this.IncludeTagsList.Name = "IncludeTagsList";
			this.IncludeTagsList.Size = new System.Drawing.Size(144, 214);
			this.IncludeTagsList.TabIndex = 0;
			this.IncludeTagsList.ThreeDCheckBoxes = true;
			this.IncludeTagsList.SelectedIndexChanged += new System.EventHandler(this.IncludeTagsList_SelectedIndexChanged);
			// 
			// IncludeRatingLabel
			// 
			this.IncludeRatingLabel.Location = new System.Drawing.Point(168, 96);
			this.IncludeRatingLabel.Name = "IncludeRatingLabel";
			this.IncludeRatingLabel.Size = new System.Drawing.Size(100, 16);
			this.IncludeRatingLabel.TabIndex = 5;
			this.IncludeRatingLabel.Text = "Rating:";
			// 
			// ExcludeGroupBox
			// 
			this.ExcludeGroupBox.Controls.Add(this.ExcludeRatingsList);
			this.ExcludeGroupBox.Controls.Add(this.ExcludeTagsLabel);
			this.ExcludeGroupBox.Controls.Add(this.ExcludeOwnersLabel);
			this.ExcludeGroupBox.Controls.Add(this.ExcludeOwnersList);
			this.ExcludeGroupBox.Controls.Add(this.ExcludeTagsList);
			this.ExcludeGroupBox.Controls.Add(this.ExcludeRatingsLabel);
			this.ExcludeGroupBox.Location = new System.Drawing.Point(328, 8);
			this.ExcludeGroupBox.Name = "ExcludeGroupBox";
			this.ExcludeGroupBox.Size = new System.Drawing.Size(304, 216);
			this.ExcludeGroupBox.TabIndex = 6;
			this.ExcludeGroupBox.TabStop = false;
			this.ExcludeGroupBox.Text = "Exclude";
			this.ExcludeGroupBox.Visible = false;
			// 
			// ExcludeRatingsList
			// 
			this.ExcludeRatingsList.Location = new System.Drawing.Point(168, 112);
			this.ExcludeRatingsList.Name = "ExcludeRatingsList";
			this.ExcludeRatingsList.Size = new System.Drawing.Size(120, 79);
			this.ExcludeRatingsList.TabIndex = 4;
			// 
			// ExcludeTagsLabel
			// 
			this.ExcludeTagsLabel.Location = new System.Drawing.Point(16, 24);
			this.ExcludeTagsLabel.Name = "ExcludeTagsLabel";
			this.ExcludeTagsLabel.Size = new System.Drawing.Size(136, 16);
			this.ExcludeTagsLabel.TabIndex = 3;
			this.ExcludeTagsLabel.Text = "Exclude Tags:";
			// 
			// ExcludeOwnersLabel
			// 
			this.ExcludeOwnersLabel.Location = new System.Drawing.Point(168, 24);
			this.ExcludeOwnersLabel.Name = "ExcludeOwnersLabel";
			this.ExcludeOwnersLabel.Size = new System.Drawing.Size(100, 16);
			this.ExcludeOwnersLabel.TabIndex = 2;
			this.ExcludeOwnersLabel.Text = "Owner:";
			// 
			// ExcludeOwnersList
			// 
			this.ExcludeOwnersList.Location = new System.Drawing.Point(168, 40);
			this.ExcludeOwnersList.Name = "ExcludeOwnersList";
			this.ExcludeOwnersList.Size = new System.Drawing.Size(120, 49);
			this.ExcludeOwnersList.TabIndex = 1;
			// 
			// ExcludeTagsList
			// 
			this.ExcludeTagsList.Location = new System.Drawing.Point(16, 40);
			this.ExcludeTagsList.Name = "ExcludeTagsList";
			this.ExcludeTagsList.Size = new System.Drawing.Size(144, 154);
			this.ExcludeTagsList.TabIndex = 0;
			// 
			// ExcludeRatingsLabel
			// 
			this.ExcludeRatingsLabel.Location = new System.Drawing.Point(168, 96);
			this.ExcludeRatingsLabel.Name = "ExcludeRatingsLabel";
			this.ExcludeRatingsLabel.Size = new System.Drawing.Size(100, 16);
			this.ExcludeRatingsLabel.TabIndex = 5;
			this.ExcludeRatingsLabel.Text = "Rating:";
			// 
			// ResetButton
			// 
			this.ResetButton.Location = new System.Drawing.Point(160, 288);
			this.ResetButton.Name = "ResetButton";
			this.ResetButton.TabIndex = 7;
			this.ResetButton.Text = "Reset";
			// 
			// CloseButton
			// 
			this.CloseButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.CloseButton.Location = new System.Drawing.Point(240, 288);
			this.CloseButton.Name = "CloseButton";
			this.CloseButton.TabIndex = 8;
			this.CloseButton.Text = "Cancel";
			this.CloseButton.Click += new System.EventHandler(this.CloseButton_Click);
			// 
			// ApplyButton
			// 
			this.ApplyButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.ApplyButton.Location = new System.Drawing.Point(80, 288);
			this.ApplyButton.Name = "ApplyButton";
			this.ApplyButton.TabIndex = 9;
			this.ApplyButton.Text = "OK";
			this.ApplyButton.Click += new System.EventHandler(this.ApplyButton_Click);
			// 
			// FilterForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(322, 320);
			this.Controls.Add(this.ApplyButton);
			this.Controls.Add(this.CloseButton);
			this.Controls.Add(this.ResetButton);
			this.Controls.Add(this.IncludeGroupBox);
			this.Controls.Add(this.ExcludeGroupBox);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.Name = "FilterForm";
			this.Text = "FilterForm";
			this.Load += new System.EventHandler(this.FilterForm_Load);
			this.IncludeGroupBox.ResumeLayout(false);
			this.ExcludeGroupBox.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void PopulateListbox(CheckedListBox listBox, StringCollection checkedStrings, string sqlQuery)
		{
			listBox.Items.Clear();

			DataSet ds = MusicLib.SqlQueryDataSet(sqlQuery);
			foreach (DataRow row in ds.Tables[0].Rows)
			{
				string itemText = row[0].ToString();
				int idx = listBox.Items.Add(itemText);
				if (checkedStrings != null && checkedStrings.Contains(itemText))
				{
					listBox.SetItemChecked(idx, true);
				};
			}
		}

		private void PopulateRatingListbox(CheckedListBox listBox, StringCollection checkedStrings)
		{
			for (int i=1; i<=9; i++)
			{
				string itemText = i.ToString();
				int idx = listBox.Items.Add(itemText);
				if (checkedStrings.Contains(itemText))
				{
					listBox.SetItemChecked(idx, true);
				};
			}
		}

		private void FilterForm_Load(object sender, System.EventArgs e)
		{
		  PopulateListbox(IncludeOwnersList, Filters.IncludeOwners, "select user_Name from Users order by user_Name");
			PopulateListbox(IncludeTagsList, Filters.IncludeTags, "select tag_Name from tags order by tag_Name");
			PopulateRatingListbox(IncludeRatingsList, Filters.IncludeRatings);

			PopulateListbox(ExcludeOwnersList, Filters.ExcludeOwners, "select user_Name from Users order by user_Name");
			PopulateListbox(ExcludeTagsList, Filters.ExcludeTags, "select tag_Name from tags order by tag_Name");
			PopulateRatingListbox(ExcludeRatingsList, Filters.ExcludeRatings);
		}

		private void CloseButton_Click(object sender, System.EventArgs e)
		{
			BrowserWindow.ActiveFilterForm = null;
			Close();
		}

		private void CheckedItemsToCollection(StringCollection coll, CheckedListBox listBox)
		{
			coll.Clear();

			foreach (object o in listBox.CheckedItems)
			{
				coll.Add(o.ToString());
			}
		}

		private void ApplyButton_Click(object sender, System.EventArgs e)
		{
			// Copy the checked items out of the lists and into
			// the Filters class
			CheckedItemsToCollection(Filters.IncludeTags, IncludeTagsList);
			CheckedItemsToCollection(Filters.IncludeOwners, IncludeOwnersList);
			CheckedItemsToCollection(Filters.IncludeRatings, IncludeRatingsList);

			CheckedItemsToCollection(Filters.ExcludeTags, ExcludeTagsList);
			CheckedItemsToCollection(Filters.ExcludeOwners, ExcludeOwnersList);
			CheckedItemsToCollection(Filters.ExcludeRatings, ExcludeRatingsList);

			BrowserWindow.RepopulateGroupList();

			Close();
		}

		private void IncludeTagsList_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		
		}
	}
}
