using System;
using System.Drawing;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Diagnostics;
using System.Windows.Forms;
using System.Configuration;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using MarcObjects;
using System.Runtime.Serialization.Formatters;

namespace Marc
{
	/// <summary>
	/// Summary description for Browser.
	/// </summary>
	public class Browser : System.Windows.Forms.Form, System.Windows.Forms.IMessageFilter
	{
		private System.Windows.Forms.ListBox GroupListBox;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Timers.Timer UpdateTimer;
		private System.Windows.Forms.ListView SongListView;
		private System.Windows.Forms.ContextMenu SongMenu;
		private System.Windows.Forms.ComboBox CurrentUserCombo;

		private System.Random randomNumbers = new System.Random();
		private bool StoppedByUser = false;
		private System.Windows.Forms.ContextMenu FilterMenu;

		public MusicLibrary MusicLib;
		public ServiceCore Core;

		// This flag is used in the event handler for the media
		// player PlayStateChange event.  We get an event when
		// the stream is ending, and another one when it's
		// actually stopped.  We can't play until it's actually
		// stopped, but when that one comes in, we don't know if
		// the stop is because of end of stream or because the
		// user pressed Stop - so when the end of stream event
		// comes in, we set this flag.
		private bool playOnNextStopEvent = false;

		TcpChannel Channel;
		PlayerClient player;

		public FilterForm ActiveFilterForm = null;
		int CurrentUserID;
		private System.Windows.Forms.ComboBox PresetCombo;
		private System.Windows.Forms.TextBox SearchTextBox;

		// Set this so that when we're selecting nodes en masse
		// we don't trigger an update for each one
		bool IgnoreGroupListSelection;

		// Global display name of this player
		private string ThisPlayerName;

		// Flag:  When a timer is going to update the lists,
		// should it update the group list as well?  Or just
		// the song list.  It's false when you click on something
		// in the artist list since selecting something from
		// there will never change that list's contents
		bool TimerUpdateGroupList = false;

		public FilterSet CurrentFilters = new FilterSet();
		private System.Windows.Forms.ComboBox PlayerCombo;
		private System.Windows.Forms.Label PlayerLabel;
		private System.Timers.Timer RegisterPlayerTimer;
		string NowPlayingFullPath;
		private System.Timers.Timer SongTickTimer;
		private AxWMPLib.AxWindowsMediaPlayer axWindowsMediaPlayer;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem PlayRandomMenuItem;
		private System.Windows.Forms.MenuItem LocatePlayingMenuItem;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem MaintainDatabaseMenuItem;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem NewPlaylistMenuItem;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem AboutMenuItem;
		private System.Windows.Forms.Panel playerPanel;
		private System.Windows.Forms.Label timeRemainingLabel;
		private System.Windows.Forms.Button playButton;
		private System.Windows.Forms.Button stopButton;
		private System.Windows.Forms.Button skipButton;
		private System.Windows.Forms.Label playingLabel;
		private System.Windows.Forms.TrackBar positionBar;

		// The X position where the right list starts when in
		// two list mode
		int ListSplitLocation;

		public Browser()
		{
			// Now try to connect with the server
			try
			{
#if true
				// This path registers the player itself as the player we talk to 
				// when the user wants to send a control to another player.. this 
				// short circuits the trip through the server, and breaks the ability
				// to control another player, but the other code is experimental and 
				// when you just want to listen to some music, this is the path 
				// that works.
				BinaryServerFormatterSinkProvider provider = new BinaryServerFormatterSinkProvider();
				provider.TypeFilterLevel = TypeFilterLevel.Full;

				Hashtable ht = new Hashtable();
				ht.Add("port", 9935);
				Channel = new TcpChannel(ht, null, provider);
				ChannelServices.RegisterChannel(Channel);

				// Create and register the office
				RemotingServices.Marshal(new ServiceCore(), "ServiceCore");
				string ServiceCorePath = String.Format("tcp://localhost:9935/ServiceCore");
#else
				// Register the channel we're going to use to communicate
				// with the server
				Channel = new TcpChannel(0);
				ChannelServices.RegisterChannel(Channel);
				string ServiceCorePath = String.Format("tcp://athlonxp:9933/ServiceCore");
#endif

				// Locate the core services object
				Core = (ServiceCore)Activator.GetObject(typeof(ServiceCore), ServiceCorePath);
				MusicLib = Core.GetMusicLibrary();
			
				// Create the player client object, cast it to a PlayerClient, and
				// pass in a reference to it.
				ThisPlayerName = ConfigurationSettings.AppSettings["PlayerName"];
				if (ThisPlayerName == null)
				{
					ThisPlayerName = "Music Player";
				};

				player = new LibraryPlayerClient(this, ThisPlayerName, Core);
				Core.RegisterPlayer(ThisPlayerName, ref player);
			} 
			catch (Exception ex)
			{
				MessageBox.Show("The server is not available.\n" + ex.Message);
				this.Close();
				Application.Exit();
				return;
			};

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			Application.AddMessageFilter(this);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Browser));
			this.GroupListBox = new System.Windows.Forms.ListBox();
			this.UpdateTimer = new System.Timers.Timer();
			this.SongListView = new System.Windows.Forms.ListView();
			this.SongMenu = new System.Windows.Forms.ContextMenu();
			this.CurrentUserCombo = new System.Windows.Forms.ComboBox();
			this.FilterMenu = new System.Windows.Forms.ContextMenu();
			this.PresetCombo = new System.Windows.Forms.ComboBox();
			this.SearchTextBox = new System.Windows.Forms.TextBox();
			this.PlayerCombo = new System.Windows.Forms.ComboBox();
			this.PlayerLabel = new System.Windows.Forms.Label();
			this.RegisterPlayerTimer = new System.Timers.Timer();
			this.SongTickTimer = new System.Timers.Timer();
			this.axWindowsMediaPlayer = new AxWMPLib.AxWindowsMediaPlayer();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.PlayRandomMenuItem = new System.Windows.Forms.MenuItem();
			this.LocatePlayingMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.MaintainDatabaseMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.NewPlaylistMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.AboutMenuItem = new System.Windows.Forms.MenuItem();
			this.playerPanel = new System.Windows.Forms.Panel();
			this.positionBar = new System.Windows.Forms.TrackBar();
			this.playingLabel = new System.Windows.Forms.Label();
			this.skipButton = new System.Windows.Forms.Button();
			this.stopButton = new System.Windows.Forms.Button();
			this.playButton = new System.Windows.Forms.Button();
			this.timeRemainingLabel = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.UpdateTimer)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.RegisterPlayerTimer)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.SongTickTimer)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.axWindowsMediaPlayer)).BeginInit();
			this.playerPanel.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.positionBar)).BeginInit();
			this.SuspendLayout();
			// 
			// GroupListBox
			// 
			this.GroupListBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.GroupListBox.Location = new System.Drawing.Point(8, 40);
			this.GroupListBox.Name = "GroupListBox";
			this.GroupListBox.SelectionMode = System.Windows.Forms.SelectionMode.MultiExtended;
			this.GroupListBox.Size = new System.Drawing.Size(176, 264);
			this.GroupListBox.Sorted = true;
			this.GroupListBox.TabIndex = 0;
			this.GroupListBox.SelectedIndexChanged += new System.EventHandler(this.GroupListBox_SelectedIndexChanged);
			// 
			// UpdateTimer
			// 
			this.UpdateTimer.SynchronizingObject = this;
			this.UpdateTimer.Elapsed += new System.Timers.ElapsedEventHandler(this.UpdateTimer_Elapsed);
			// 
			// SongListView
			// 
			this.SongListView.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.SongListView.ContextMenu = this.SongMenu;
			this.SongListView.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.SongListView.HideSelection = false;
			this.SongListView.Location = new System.Drawing.Point(192, 40);
			this.SongListView.Name = "SongListView";
			this.SongListView.Size = new System.Drawing.Size(424, 256);
			this.SongListView.TabIndex = 3;
			this.SongListView.View = System.Windows.Forms.View.Details;
			this.SongListView.DoubleClick += new System.EventHandler(this.SongListView_DoubleClick);
			this.SongListView.SelectedIndexChanged += new System.EventHandler(this.SongListView_SelectedIndexChanged);
			// 
			// SongMenu
			// 
			this.SongMenu.Popup += new System.EventHandler(this.SongMenu_Popup);
			// 
			// CurrentUserCombo
			// 
			this.CurrentUserCombo.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.CurrentUserCombo.Location = new System.Drawing.Point(8, 8);
			this.CurrentUserCombo.Name = "CurrentUserCombo";
			this.CurrentUserCombo.Size = new System.Drawing.Size(112, 21);
			this.CurrentUserCombo.TabIndex = 7;
			this.CurrentUserCombo.SelectedIndexChanged += new System.EventHandler(this.CurrentUserCombo_SelectedIndexChanged);
			// 
			// PresetCombo
			// 
			this.PresetCombo.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.PresetCombo.Location = new System.Drawing.Point(128, 8);
			this.PresetCombo.MaxDropDownItems = 30;
			this.PresetCombo.Name = "PresetCombo";
			this.PresetCombo.Size = new System.Drawing.Size(176, 21);
			this.PresetCombo.TabIndex = 9;
			this.PresetCombo.SelectedIndexChanged += new System.EventHandler(this.PresetCombo_SelectedIndexChanged);
			// 
			// SearchTextBox
			// 
			this.SearchTextBox.Location = new System.Drawing.Point(312, 8);
			this.SearchTextBox.Name = "SearchTextBox";
			this.SearchTextBox.Size = new System.Drawing.Size(152, 20);
			this.SearchTextBox.TabIndex = 10;
			this.SearchTextBox.Text = "";
			this.SearchTextBox.TextChanged += new System.EventHandler(this.SearchTextBox_TextChanged);
			// 
			// PlayerCombo
			// 
			this.PlayerCombo.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.PlayerCombo.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.PlayerCombo.Location = new System.Drawing.Point(8, 336);
			this.PlayerCombo.MaxDropDownItems = 30;
			this.PlayerCombo.Name = "PlayerCombo";
			this.PlayerCombo.Size = new System.Drawing.Size(176, 21);
			this.PlayerCombo.TabIndex = 13;
			this.PlayerCombo.SelectedIndexChanged += new System.EventHandler(this.PlayerCombo_SelectedIndexChanged);
			// 
			// PlayerLabel
			// 
			this.PlayerLabel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.PlayerLabel.Location = new System.Drawing.Point(8, 320);
			this.PlayerLabel.Name = "PlayerLabel";
			this.PlayerLabel.Size = new System.Drawing.Size(100, 16);
			this.PlayerLabel.TabIndex = 14;
			this.PlayerLabel.Text = "Player:";
			// 
			// RegisterPlayerTimer
			// 
			this.RegisterPlayerTimer.Enabled = true;
			this.RegisterPlayerTimer.Interval = 60000;
			this.RegisterPlayerTimer.SynchronizingObject = this;
			this.RegisterPlayerTimer.Elapsed += new System.Timers.ElapsedEventHandler(this.RegisterPlayerTimer_Elapsed);
			// 
			// SongTickTimer
			// 
			this.SongTickTimer.Enabled = true;
			this.SongTickTimer.Interval = 1000;
			this.SongTickTimer.SynchronizingObject = this;
			this.SongTickTimer.Elapsed += new System.Timers.ElapsedEventHandler(this.SongTickTimer_Elapsed);
			// 
			// axWindowsMediaPlayer
			// 
			this.axWindowsMediaPlayer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.axWindowsMediaPlayer.Enabled = true;
			this.axWindowsMediaPlayer.Location = new System.Drawing.Point(520, 8);
			this.axWindowsMediaPlayer.Name = "axWindowsMediaPlayer";
			this.axWindowsMediaPlayer.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axWindowsMediaPlayer.OcxState")));
			this.axWindowsMediaPlayer.Size = new System.Drawing.Size(424, 48);
			this.axWindowsMediaPlayer.TabIndex = 18;
			this.axWindowsMediaPlayer.Visible = false;
			this.axWindowsMediaPlayer.PlayStateChange += new AxWMPLib._WMPOCXEvents_PlayStateChangeEventHandler(this.axWindowsMediaPlayer_PlayStateChange);
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																							this.menuItem1,
																																							this.menuItem3,
																																							this.menuItem6,
																																							this.menuItem8,
																																							this.menuItem4});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																							this.menuItem2});
			this.menuItem1.Text = "&File";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Text = "&Exit";
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																							this.PlayRandomMenuItem,
																																							this.LocatePlayingMenuItem});
			this.menuItem3.Text = "&Play";
			// 
			// PlayRandomMenuItem
			// 
			this.PlayRandomMenuItem.Index = 0;
			this.PlayRandomMenuItem.Shortcut = System.Windows.Forms.Shortcut.F5;
			this.PlayRandomMenuItem.Text = "&Play Random";
			this.PlayRandomMenuItem.Click += new System.EventHandler(this.PlayRandomMenuItem_Click);
			// 
			// LocatePlayingMenuItem
			// 
			this.LocatePlayingMenuItem.Index = 1;
			this.LocatePlayingMenuItem.Text = "&Locate Playing";
			this.LocatePlayingMenuItem.Click += new System.EventHandler(this.LocatePlayingMenuItem_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 2;
			this.menuItem6.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																							this.MaintainDatabaseMenuItem});
			this.menuItem6.Text = "&Tools";
			// 
			// MaintainDatabaseMenuItem
			// 
			this.MaintainDatabaseMenuItem.Index = 0;
			this.MaintainDatabaseMenuItem.Text = "&Maintain database...";
			this.MaintainDatabaseMenuItem.Click += new System.EventHandler(this.MaintainDatabaseMenuItem_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 3;
			this.menuItem8.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																							this.NewPlaylistMenuItem});
			this.menuItem8.Text = "&Playlist";
			// 
			// NewPlaylistMenuItem
			// 
			this.NewPlaylistMenuItem.Index = 0;
			this.NewPlaylistMenuItem.Text = "&New Playlist...";
			this.NewPlaylistMenuItem.Click += new System.EventHandler(this.NewPlaylistMenuItem_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 4;
			this.menuItem4.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																							this.AboutMenuItem});
			this.menuItem4.Text = "&Help";
			// 
			// AboutMenuItem
			// 
			this.AboutMenuItem.Index = 0;
			this.AboutMenuItem.Text = "&About...";
			// 
			// playerPanel
			// 
			this.playerPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.playerPanel.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.playerPanel.Controls.Add(this.positionBar);
			this.playerPanel.Controls.Add(this.playingLabel);
			this.playerPanel.Controls.Add(this.skipButton);
			this.playerPanel.Controls.Add(this.stopButton);
			this.playerPanel.Controls.Add(this.playButton);
			this.playerPanel.Controls.Add(this.timeRemainingLabel);
			this.playerPanel.Location = new System.Drawing.Point(192, 304);
			this.playerPanel.Name = "playerPanel";
			this.playerPanel.Size = new System.Drawing.Size(424, 56);
			this.playerPanel.TabIndex = 19;
			// 
			// positionBar
			// 
			this.positionBar.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.positionBar.Location = new System.Drawing.Point(200, 22);
			this.positionBar.Name = "positionBar";
			this.positionBar.Size = new System.Drawing.Size(216, 45);
			this.positionBar.TabIndex = 5;
			this.positionBar.TickStyle = System.Windows.Forms.TickStyle.None;
			this.positionBar.Scroll += new System.EventHandler(this.positionBar_Scroll);
			// 
			// playingLabel
			// 
			this.playingLabel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.playingLabel.Location = new System.Drawing.Point(8, 4);
			this.playingLabel.Name = "playingLabel";
			this.playingLabel.Size = new System.Drawing.Size(328, 14);
			this.playingLabel.TabIndex = 4;
			this.playingLabel.Text = "Stopped.";
			// 
			// skipButton
			// 
			this.skipButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.skipButton.Location = new System.Drawing.Point(136, 24);
			this.skipButton.Name = "skipButton";
			this.skipButton.Size = new System.Drawing.Size(56, 23);
			this.skipButton.TabIndex = 3;
			this.skipButton.Text = "Next";
			this.skipButton.Click += new System.EventHandler(this.skipButton_Click);
			// 
			// stopButton
			// 
			this.stopButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.stopButton.Location = new System.Drawing.Point(72, 24);
			this.stopButton.Name = "stopButton";
			this.stopButton.Size = new System.Drawing.Size(56, 23);
			this.stopButton.TabIndex = 2;
			this.stopButton.Text = "Stop";
			this.stopButton.Click += new System.EventHandler(this.stopButton_Click);
			// 
			// playButton
			// 
			this.playButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.playButton.Location = new System.Drawing.Point(8, 24);
			this.playButton.Name = "playButton";
			this.playButton.Size = new System.Drawing.Size(56, 23);
			this.playButton.TabIndex = 1;
			this.playButton.Text = "Play";
			this.playButton.Click += new System.EventHandler(this.playButton_Click);
			// 
			// timeRemainingLabel
			// 
			this.timeRemainingLabel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.timeRemainingLabel.Location = new System.Drawing.Point(344, 4);
			this.timeRemainingLabel.Name = "timeRemainingLabel";
			this.timeRemainingLabel.Size = new System.Drawing.Size(64, 14);
			this.timeRemainingLabel.TabIndex = 0;
			this.timeRemainingLabel.Text = "label1";
			this.timeRemainingLabel.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// Browser
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(624, 366);
			this.Controls.Add(this.playerPanel);
			this.Controls.Add(this.axWindowsMediaPlayer);
			this.Controls.Add(this.PlayerLabel);
			this.Controls.Add(this.PlayerCombo);
			this.Controls.Add(this.SearchTextBox);
			this.Controls.Add(this.PresetCombo);
			this.Controls.Add(this.CurrentUserCombo);
			this.Controls.Add(this.SongListView);
			this.Controls.Add(this.GroupListBox);
			this.Menu = this.mainMenu1;
			this.MinimumSize = new System.Drawing.Size(544, 360);
			this.Name = "Browser";
			this.Text = "Marc Player";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Browser_Closing);
			this.Load += new System.EventHandler(this.Browser_Load);
			this.Closed += new System.EventHandler(this.Browser_Closed);
			((System.ComponentModel.ISupportInitialize)(this.UpdateTimer)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.RegisterPlayerTimer)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.SongTickTimer)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.axWindowsMediaPlayer)).EndInit();
			this.playerPanel.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.positionBar)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void LibraryManagementButton_Click(object sender, System.EventArgs e)
		{
			ManageForm manage = new ManageForm(MusicLib, CurrentUserID);
			manage.ShowDialog(this);
		}

		public void RepopulateGroupList()
		{
			// Create the string collection
			StringCollection strings = new StringCollection();

			// Populate the string collection
			MusicLib.GetArtistsList(CurrentUserID, CurrentFilters, ref strings);

			// Place the strings into the list box
			ListToListBox(strings, GroupListBox);

			// Nothing selected in the group list, clear the song list
			SongListView.Items.Clear();
		}

		private void ListToListBox(StringCollection strings, ListBox theListBox)
		{
			// Hide it while we update
			theListBox.Visible = false;

			// Remove whatever's there now
			theListBox.Items.Clear();

			foreach (string ItemText in strings)
			{
				theListBox.Items.Add(ItemText);
			};

			theListBox.Visible = true;
		}

		private void Browser_Load(object sender, System.EventArgs e)
		{
			ListSplitLocation = SongListView.Left;

			PopulateUserCombo();
			RepopulateGroupList();

			NowPlayingFullPath = "";

			PopulatePlayersList(false);
		}

		// This has to be done per user since the list of 
		// playlists will change when we change users
		private void PopulatePresetCombo()
		{
			PresetCombo.Items.Clear();

			int NewTagID = MusicLib.GetTagID("New");

			int allIndex = PresetCombo.Items.Add(new NameStringPair("All Songs", "ALL"));
			PresetCombo.Items.Add(new NameStringPair("Songs I Like (>4)", "SQL song_Missing = 0 and rating_Value > 4"));
			PresetCombo.Items.Add(new NameStringPair("Songs I Love (>7)", "SQL song_Missing = 0 and rating_Value > 7"));
			PresetCombo.Items.Add(new NameStringPair("Songs I Hate (<3)", "SQL song_Missing = 0 and rating_Value < 3"));
			PresetCombo.Items.Add(new NameStringPair("New Songs", "SQL (song_Missing = 0) and tagassoc_TagID = " + NewTagID.ToString()));
			PresetCombo.Items.Add(new NameStringPair("Unrated Songs", "SQL (song_Missing = 0) and rating_Value is null"));
			PresetCombo.Items.Add(new NameStringPair("Untagged Songs", "SQL (song_Missing = 0) and (NOT EXISTS (SELECT tagassoc_ID FROM TagAssoc WHERE tagassoc_SongID = song_ID))"));
			PresetCombo.Items.Add(new NameStringPair("SQL Query", "RawSql"));

			// Add the playlists
			StringCollection coll = MusicLib.GetPlaylistList(CurrentUserID);
			if (coll != null)
			{
				foreach (string str in coll)
				{
					PresetCombo.Items.Add(new NameStringPair("Playlist: " + str, "PLST " + str));
				};
			};

			PresetCombo.Items.Add(new NameStringPair("Search...", "FullTextSearch"));
			PresetCombo.Items.Add(new NameStringPair("Custom...", "Custom"));
			PresetCombo.SelectedIndex = allIndex;
			PresetCombo.Sorted = false;
		}

		private void PopulatePlayersList(bool PreserveSelection)
		{
			// Populate the connected players list
			string DefaultPlayer;

			if (PreserveSelection)
				DefaultPlayer = PlayerCombo.SelectedItem.ToString();
			else
				DefaultPlayer = ConfigurationSettings.AppSettings["DefaultPlayer"];
			
			StringCollection players = Core.GetPlayersList();
			PlayerCombo.Items.Clear();

			bool playerSelected = false;
			foreach (string player in players)
			{
				int idx = PlayerCombo.Items.Add(player);
				if (DefaultPlayer != null && 
					 player.ToUpper() == DefaultPlayer.ToUpper())
				{
					PlayerCombo.SelectedIndex = idx;
					playerSelected = true;
				};
			};

			// Select one if there still isn't one selected
			if (!playerSelected)
			{
				PlayerCombo.SelectedIndex = 0;
			};
		}

		private void PopulateUserCombo()
		{
			// Get the name of the current user from the config file
			string CurrentUser = ConfigurationSettings.AppSettings["CurrentUser"];

			// Get the users list from the database
			StringCollection users = MusicLib.GetUsersList();

			// Populate the combo
			CurrentUserCombo.Items.Clear();
			foreach (string user in users)
			{
				int idx = CurrentUserCombo.Items.Add(user);
				if (user.ToUpper() == CurrentUser.ToUpper())
				{
					CurrentUserCombo.SelectedIndex = idx;
				};
			}

			// Determine the current user ID
			CurrentUserID = MusicLib.GetUserID(CurrentUserCombo.SelectedItem.ToString());
		}

		private void GroupListBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!IgnoreGroupListSelection)
			{
				TimerUpdateGroupList = false;
				UpdateTimer.Interval = 100;
				UpdateTimer.Start();
			}
		}

		private void UpdateTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			UpdateTimer.Stop();
			UpdateTimer.Enabled = false;

			if (TimerUpdateGroupList)
			{
				RepopulateGroupList();
			};

			RepopulateSongList();
		}

		private void RepopulateSongList()
		{
			// Get an enum object to pass to QuerySongList so it knows
			// which artists are currently selected
			StringCollection artists = new StringCollection();
			if (GroupListBox.Visible)
			{
				// Only if the group list box is visible does the artist list matter
				foreach (string artist in GroupListBox.SelectedItems)
				{
					artists.Add(artist);
				};
			};

			// Request the song list data set
			try
			{
				DataSet ds = MusicLib.QuerySongList(CurrentFilters, artists, CurrentUserID);

				// Prepare to update the list view
				SongListView.Items.Clear();
				SongListView.BeginUpdate();

				// Copy it into the list view
				foreach (DataRow row in ds.Tables[0].Rows)
				{
					ListViewItem item = new ListViewItem();

					string SongPath = row["song_FullPath"].ToString();

					int idx = SongPath.LastIndexOf('\\');
					if (idx == -1 || idx >= (SongPath.Length-1))
					{
						item.Text = SongPath;
					} 
					else
					{
						item.Text = SongPath.Substring(idx+1);
					};

					// The Tag field is the key (song path)
					item.Tag = SongPath;

					item.SubItems.Add(row["song_Album"].ToString());
					item.SubItems.Add(row["user_Name"].ToString());

					if (row["rating_Value"] != null)
					{
						item.SubItems.Add(row["rating_Value"].ToString());
					};

					// Add the item
					SongListView.Items.Add(item);
				};
			} 
			catch (Exception)
			{
			};

			// Add the columns themselves
			SongListView.Columns.Clear();
			SongListView.Columns.Add("Song name", 500, HorizontalAlignment.Left);
			SongListView.Columns.Add("Album", 200, HorizontalAlignment.Left);
			SongListView.Columns.Add("Owner", 100, HorizontalAlignment.Left);
			SongListView.Columns.Add("Rating", 50, HorizontalAlignment.Left);

			// Allow it to redraw itself
			SongListView.EndUpdate();
		}

		private void SongListView_DoubleClick(object sender, System.EventArgs e)
		{
			PlaySong(SongListView.SelectedItems[0].Tag.ToString());
		}

		private void SongListView_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		}

		private void PlaySong(string FullPath)
		{
			try
			{
				string Player = PlayerCombo.SelectedItem.ToString();
				if (Player == ThisPlayerName)
				{
					Player_PlaySong(FullPath);
				} 
				else
				{
					// Start it playing
					Core.PlaySong(FullPath, PlayerCombo.SelectedItem.ToString());
				};

				// Log that we listened to it
				MusicLib.LogListen(CurrentUserID, FullPath);
			} 
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			};
		}

		private void PlayNextSong()
		{
			axWindowsMediaPlayer.Ctlcontrols.stop();

			NowPlayingFullPath = "";

			if (SongListView.Items.Count == 0)
			{
				GroupListBox.Visible = false;
				IgnoreGroupListSelection = true;
				for (int i=0; i<GroupListBox.Items.Count; i++)
					GroupListBox.SetSelected(i, true);
				IgnoreGroupListSelection = false;
				GroupListBox.Visible = true;

				RepopulateSongList();

				// Still no songs?
				if (SongListView.Items.Count == 0)
				{
					return;
				}
			};

			if (SongListView.SelectedItems.Count == 0)
			{
				// Play a random one
				int nextIndex = randomNumbers.Next(SongListView.Items.Count);
				PlaySong(SongListView.Items[nextIndex].Tag.ToString());
			} 
			else
			{
				// Play the first selected one
				PlaySong(SongListView.SelectedItems[0].Tag.ToString());
			};
		}

		private void StopButton_Click(object sender, System.EventArgs e)
		{
			Core.PlayerControl(PlayerCombo.SelectedItem.ToString(), "Stop");
			StoppedByUser = true;
		}

		void SongMenu_NewTag(object sender, System.EventArgs e)
		{
			StringRequestForm tagForm = new StringRequestForm();
			tagForm.StringTextBox.Text = "";
			tagForm.StringLabel.Text = "New tag name";
			tagForm.Text = "Add Tag";
			if (tagForm.ShowDialog(this) == DialogResult.OK)
			{
				if (tagForm.StringTextBox.Text.Length > 0)
				{
					if (tagForm.StringTextBox.Text.IndexOf("(") > 0)
					{
						MessageBox.Show("You cannot have brackets in a tag name.");
					} 
					else
					{
						MusicLib.AddTag(tagForm.StringTextBox.Text);
					};
				};
			};
		}

		void SongMenu_PlayClick(object sender, System.EventArgs e)
		{
			PlayNextSong();
		}

		void SongMenu_RemoveFromPlaylistClick(object sender, System.EventArgs e)
		{
			NameStringPair item = (NameStringPair)PresetCombo.SelectedItem;
			if (item.Value.StartsWith("PLST "))
			{
				int PlaylistID = MusicLib.GetPlaylistID(CurrentUserID, item.Value.Substring(5));
				if (PlaylistID != 0)
				{
					// TODO: Add a mechanism for batch removing songs
					foreach (ListViewItem selectedItem in SongListView.SelectedItems)
					{
						string ProcessingSong = selectedItem.Tag.ToString();
						MusicLib.RemoveSongFromPlaylist(CurrentUserID, ProcessingSong, PlaylistID);
					};
				};

				RepopulateSongList();
			};
		}

		void SongMenu_AddToPlaylistClick(object sender, System.EventArgs e)
		{
			string ProcessingSong = "";

			try
			{
				MenuItem item = (MenuItem)sender;
				string playlistName = item.Text;
				int PlaylistID = MusicLib.GetPlaylistID(CurrentUserID, playlistName);
				if (PlaylistID != 0)
				{
					// TODO: Add a mechanism for batch adding songs
					foreach (ListViewItem selectedItem in SongListView.SelectedItems)
					{
						ProcessingSong = selectedItem.Tag.ToString();
						MusicLib.AddSongToPlaylist(CurrentUserID, ProcessingSong, PlaylistID);
					};
				};
			} 
			catch (Exception ex)
			{
				// Hmm
				MessageBox.Show(ex.Message);
			};
		}

		void SongMenu_OwnerClick(object sender, System.EventArgs e)
		{
			MenuItem item = (MenuItem)sender;
			string newOwner = item.Text;

			// Change the owner of each selected item
			foreach (ListViewItem selectedItem in SongListView.SelectedItems)
			{
				MusicLib.SetSongOwner(selectedItem.Tag.ToString(), CurrentUserID);
				selectedItem.SubItems[2].Text = newOwner;
			};
		}

		void SongMenu_RatingClick(object sender, System.EventArgs e)
		{
			MenuItem item = (MenuItem)sender;
			int newRating = Int32.Parse(item.Text.Substring(0, 1));

			// Change the owner of each selected item
			foreach (ListViewItem selectedItem in SongListView.SelectedItems)
			{
				string FullPath = selectedItem.Tag.ToString();
				MusicLib.SetSongRating(FullPath, CurrentUserID, newRating);
				selectedItem.SubItems[3].Text = newRating.ToString();
			};
		}

		void SongMenu_TagClick(object sender, System.EventArgs e)
		{
			MenuItem item = (MenuItem)sender;
			string tagToggle = item.Text;

			string TagName = item.Text;
			if (TagName.IndexOf(" (") > 0)
			{
				TagName = TagName.Substring(0, TagName.LastIndexOf(" ("));
			};

			// Find the user ID of the new owner
			int TagID = MusicLib.GetTagID(TagName);

			// Tag the selected items
			foreach (ListViewItem selectedItem in SongListView.SelectedItems)
			{
				int SongID = MusicLib.GetSongID(selectedItem.Tag.ToString());
				
				if (item.Checked)
				{
					MusicLib.RemoveTag(SongID, TagID);
				} 
				else
				{
					MusicLib.SetTag(SongID, TagID);
				};
			};
		}

		private void SongMenu_Popup(object sender, System.EventArgs e)
		{
			// Nothing selected, nothing we can do
			if (SongListView.SelectedItems.Count == 0)
				return;

			SongMenu.MenuItems.Clear();

			// Get the list of users
			StringCollection users = MusicLib.GetUsersList();

			// Create and populate the Owner item
			MenuItem ownerItem = SongMenu.MenuItems.Add("Owner");
			foreach (string userName in users)
			{
				// Figure out how many of the selected items have this owner
				int thisCount = 0;
				foreach (ListViewItem item in SongListView.SelectedItems)
				{
					if (item.SubItems[2].Text == userName)
						thisCount++;
				};

				// Figure out if some, all, or none of the items are selected
				// and update the string accordingly.
				MenuItem userItem = new MenuItem();
				userItem.Text = userName;
				userItem.Click += new System.EventHandler(SongMenu_OwnerClick);

				if (thisCount >= SongListView.SelectedIndices.Count)
				{
					// All selected
					userItem.Checked = true;
				} 
				else
				if (thisCount != 0)
				{
					// Some selected
					userItem.Text = String.Format("{0} ({1} of {2})", userName, thisCount, SongListView.SelectedItems.Count);
				};

				// Add the item!
				ownerItem.MenuItems.Add(userItem);
			};

			MenuItem ratingItem = SongMenu.MenuItems.Add("Rate Selection");
			for (int i=1; i<=9; i++)
			{			
				MenuItem ratingSub = new MenuItem();
				ratingSub.Click += new System.EventHandler(SongMenu_RatingClick);

				if (i == 1)
				{
					ratingSub.Text = "1 (worst)";
				} 
				else
				if (i == 9)
				{
					ratingSub.Text = "9 (best)";
				} 
				else
				{
					ratingSub.Text = i.ToString();
				};

				ratingItem.MenuItems.Add(ratingSub);
			};

			// Add all the Tags items
			MenuItem tagsItem = SongMenu.MenuItems.Add("Tags");
			StringCollection songCollection = new StringCollection();
			foreach (ListViewItem selectedItem in SongListView.SelectedItems)
			{
				songCollection.Add(selectedItem.Tag.ToString());
			};

			// Get the list of tag counts
			DataSet allTags = MusicLib.SqlQueryDataSet("Select * from Tags order by tag_Name");
			DataSet tagDs = MusicLib.GetTagCountsForSongList(songCollection);
			foreach (DataRow row in allTags.Tables[0].Rows)
			{
				string tagName = (string)row["tag_Name"];
				int tagCount = 0;

				// Find the tag count in the tagDs dataset
				foreach (DataRow tagRow in tagDs.Tables[0].Rows)
				{
					if ((string)tagRow["TagName"] == tagName)
					{
						tagCount = (int)tagRow["TagCount"];
						break;
					};
				};

				MenuItem tagSub = new MenuItem();
				tagSub.Click += new System.EventHandler(SongMenu_TagClick);

				if (tagCount == 0)
				{
					// Not checked
					tagSub.Text = tagName;
				} 
				else
				if (tagCount == SongListView.SelectedItems.Count)
				{
					// Checked
					tagSub.Text = tagName.ToString();
					tagSub.Checked = true;
				} 
				else
				{
					// Not checked but partial
					tagSub.Text = tagName + String.Format(" ({0} of {1})", tagCount, SongListView.SelectedItems.Count);
				};

				tagsItem.MenuItems.Add(tagSub);
			};

			MenuItem newTagItem = new MenuItem("Add new tag...", new System.EventHandler(SongMenu_NewTag));
			tagsItem.MenuItems.Add(newTagItem);

			// If we're looking at a playlist, add the "Remove from Playlist"
			// item, otherwise, add the "Add to Playlist" item.
			NameStringPair comboItem = (NameStringPair)PresetCombo.SelectedItem;
			if (comboItem.Value.StartsWith("PLST "))
			{
				MenuItem playlistsItem = SongMenu.MenuItems.Add("Remove from this Playlist");
				playlistsItem.Click += new System.EventHandler(SongMenu_RemoveFromPlaylistClick);
			} 
			else
			{
				// Add the Add to Playlist item
				MenuItem playlistsItem = SongMenu.MenuItems.Add("Add to Playlist");
				StringCollection playlists = MusicLib.GetPlaylistList(CurrentUserID);
				foreach (string PlaylistName in playlists)
				{
					MenuItem playlistSub = new MenuItem();
					playlistSub.Text = PlaylistName;
					playlistSub.Click += new System.EventHandler(SongMenu_AddToPlaylistClick);
					playlistsItem.MenuItems.Add(playlistSub);
				};
			};
		}

		private string SongNameFromPath(string FullPath)
		{
			return FullPath.Substring(FullPath.LastIndexOf("\\")+1);
		}

		private void IncludeButton_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			// Filter by Owner
			// Filter by Rating
			// Filter by Tag
		}


		private void IncludeButton_Click(object sender, System.EventArgs e)
		{
		}

		private void CurrentUserCombo_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			CurrentUserID = MusicLib.GetUserID(CurrentUserCombo.SelectedItem.ToString());
			PopulatePresetCombo();
		}

		void SetTwoListMode()
		{
			// Update the position and size of the song list
			int SongRight = SongListView.Left + SongListView.Width;
			SongListView.Left = ListSplitLocation;
			SongListView.Width = SongRight - SongListView.Left;

			// Reveal the group list
			GroupListBox.Visible = true;
		}

		void SetOneListMode()
		{
			// Update the position and size of the song list
			int SongRight = SongListView.Left + SongListView.Width;
			SongListView.Left = GroupListBox.Left;
			SongListView.Width = SongRight - SongListView.Left;

			// Hide the group list
			GroupListBox.Visible = false;
		}

		private void PresetCombo_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			NameStringPair item = (NameStringPair)PresetCombo.SelectedItem;

			SearchTextBox.Visible = false;

			switch (item.Value)
			{
				case "ALL":
					SetTwoListMode();
					CurrentFilters = new FilterSet();
					RepopulateGroupList();
					break;

				case "Custom":
					ActiveFilterForm = new FilterForm(this);
					SetTwoListMode();
					ActiveFilterForm.Show();
					break;

				case "RawSql":
					SetOneListMode();
					SearchTextBox.Visible = true;
					break;

				case "FullTextSearch":
					SetOneListMode();
					CurrentFilters = new FilterSet();
					SearchTextBox.Visible = true;
					break;

				default:
					if (item.Value.StartsWith("PLST "))
					{
						int PlaylistID = MusicLib.GetPlaylistID(CurrentUserID, item.Value.Substring(5));
						if (PlaylistID != 0)
						{
							SetOneListMode();
							string SqlSelect = String.Format("song_Missing = 0 and (song_ID in (select playlistentry_SongID from PlayListEntries where playlistentry_PlaylistID = {0})) ", PlaylistID);
							CurrentFilters = new FilterSet(SqlSelect);
						};
						RepopulateSongList();
					};

					if (item.Value.StartsWith("SQL "))
					{
						SetTwoListMode();
						CurrentFilters = new FilterSet(item.Value.Substring(4));
						RepopulateGroupList();
					};
					break;
			};
		}

		private void SearchTextBox_TextChanged(object sender, System.EventArgs e)
		{
			NameStringPair item = (NameStringPair)PresetCombo.SelectedItem;
			if (item.Value == "RawSql")
			{
				CurrentFilters = new FilterSet(SearchTextBox.Text);
			} 
			else
			{
				CurrentFilters.SetFullTextSearch(SearchTextBox.Text);
			};

			if (UpdateTimer.Enabled)
				UpdateTimer.Stop();
													
			TimerUpdateGroupList = true;
			UpdateTimer.Interval = 200;
			UpdateTimer.Start();
		}

		private void SkipSecondsButton_Click(object sender, System.EventArgs e)
		{
			Core.PlayerControl(PlayerCombo.SelectedItem.ToString(), "Skip");
		}

		private void NewPlaylistButton_Click(object sender, System.EventArgs e)
		{
			StringRequestForm tagForm = new StringRequestForm();
			tagForm.StringTextBox.Text = "";
			tagForm.StringLabel.Text = "New Playlist name";
			tagForm.Text = "Create Playlist";
			if (tagForm.ShowDialog(this) == DialogResult.OK)
			{
				if (tagForm.StringTextBox.Text.Length > 0)
				{
					MusicLib.CreatePlaylist(CurrentUserID, tagForm.StringTextBox.Text);
				};
			};
		}

		private void Browser_Closed(object sender, System.EventArgs e)
		{
			ChannelServices.UnregisterChannel(Channel);
			Application.Exit();
		}

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
#if true
			try
#endif
			{
				Application.Run(new Browser());
			} 
#if true
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			};
#endif
 		}

		private void Browser_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
		}

		public delegate void PlaySongDelegate(string FullPath);

		public void Player_PlaySong(string FullPath)
		{
			try
			{
				if (FullPath != NowPlayingFullPath)
				{
					NowPlayingFullPath = FullPath;
					axWindowsMediaPlayer.URL = FullPath;
				};
			} 
			catch (Exception ex)
			{
				MessageBox.Show("Exception playing " + FullPath + ":\n" + ex.Message);
			};
		}

		public delegate void PlayerConrolDelegate(string Command, string Args);

		public void Player_Control(string Command, string Args)
		{
			switch (Command)
			{
				case "PlayerListChanged":
					PopulatePlayersList(true);
					break;

				case "Stop":
					axWindowsMediaPlayer.Ctlcontrols.stop();
					NowPlayingFullPath = "";
					StoppedByUser = true;
					break;

				case "Skip":
					// Not supported
					break;
			};
		}

		private void PlayerCombo_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		}

		private void RegisterPlayerTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			// Refresh the core's registration of us as a player
			Core.RegisterPlayer(player.Name, ref player);
		}

		private void SongTickTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			string str = axWindowsMediaPlayer.Ctlcontrols.currentPositionString;
			timeRemainingLabel.Text = str;

			if (this.NowPlayingFullPath != null)
			{
				int lastIdx = this.NowPlayingFullPath.LastIndexOf('\\');
				if (lastIdx != -1)
				{
					playingLabel.Text = this.NowPlayingFullPath.Substring(lastIdx+1);
				}
			} else
			{
				playingLabel.Text = "Stopped.";
			};

			// Set the trackbar to the current position
			if (axWindowsMediaPlayer.currentMedia != null)
			{
				double duration = axWindowsMediaPlayer.currentMedia.duration;
				double curpos = axWindowsMediaPlayer.Ctlcontrols.currentPosition;
				positionBar.Maximum = (int)duration;
				positionBar.Value = (int)curpos;	
				positionBar.SmallChange = 5;
				positionBar.LargeChange = 30;
			} else
			{
				positionBar.Value = 0;
			};

		}

		private void SelectSong(string FullPathToSelect)
		{
			foreach (ListViewItem selectedItem in SongListView.Items)
			{
				string ThisSong = selectedItem.Tag.ToString();
				if (ThisSong == FullPathToSelect)
				{
					SongListView.SelectedItems.Clear();
					selectedItem.Selected = true;
					SongListView.EnsureVisible(SongListView.SelectedItems[0].Index);
					SongListView.Focus();
					break;
				};
			};
		}

		#region IMessageFilter Members

		/// <summary>
		/// Code to catch a special windows message that allows simple
		/// remote control
		/// </summary>
		public bool PreFilterMessage(ref Message m)
		{
			if (m.Msg == 0x4100)
			{
				char ch = (char)m.WParam;
				if (ch >= '0' && ch <= '9')
				{
					char[] rating = new char[1];
					rating[0] = ch;
					
					SelectSong(NowPlayingFullPath);
					SongMenu_RatingClick(new MenuItem(new string(rating)), null);
				} 
				else
				{
					switch ((int)m.WParam)
					{
						case 'P':
							PlayNextSong();
							break;

						case 'S':
							StopButton_Click(null, null);
							break;

						case 'F':
							SongListView.SelectedItems.Clear();
							PlayNextSong();
							break;
					};
				};

				return true;
			};

			return false;
		}

		#endregion

		private void axWindowsMediaPlayer_PlayStateChange(object sender, AxWMPLib._WMPOCXEvents_PlayStateChangeEvent e)
		{
			Trace.WriteLine(string.Format("PlayStateChange, new state = {0}", e.newState));
			if (e.newState == 8)
			{
				playOnNextStopEvent = true;
			};

			if (e.newState == 9)
			{
				if (playOnNextStopEvent)
				{
					playOnNextStopEvent = false;

					int nextIndex = randomNumbers.Next(SongListView.Items.Count);
					PlaySong(SongListView.Items[nextIndex].Tag.ToString());
				}
			}
		}

		private void NewPlaylistMenuItem_Click(object sender, System.EventArgs e)
		{
			StringRequestForm tagForm = new StringRequestForm();
			tagForm.StringTextBox.Text = "";
			tagForm.StringLabel.Text = "New Playlist name";
			tagForm.Text = "Create Playlist";
			if (tagForm.ShowDialog(this) == DialogResult.OK)
			{
				if (tagForm.StringTextBox.Text.Length > 0)
				{
					MusicLib.CreatePlaylist(CurrentUserID, tagForm.StringTextBox.Text);
				};
			};
		}

		private void MaintainDatabaseMenuItem_Click(object sender, System.EventArgs e)
		{
			ManageForm manage = new ManageForm(MusicLib, CurrentUserID);
			manage.ShowDialog(this);
		}

		private void PlayRandomMenuItem_Click(object sender, System.EventArgs e)
		{
			PlayNextSong();
		}

		private void LocatePlayingMenuItem_Click(object sender, System.EventArgs e)
		{
			SelectSong(NowPlayingFullPath);
		}

		private void playButton_Click(object sender, System.EventArgs e)
		{
			if (SongListView.Items.Count > 0)
			{
				if (SongListView.SelectedItems.Count == 0)
					SongListView.Items[0].Selected = true;

				PlaySong(SongListView.SelectedItems[0].Tag.ToString());
			}
		}

		private void stopButton_Click(object sender, System.EventArgs e)
		{
			axWindowsMediaPlayer.Ctlcontrols.stop();
		}

		private void skipButton_Click(object sender, System.EventArgs e)
		{
			int nextIndex = randomNumbers.Next(SongListView.Items.Count);
			PlaySong(SongListView.Items[nextIndex].Tag.ToString());
		}

		private void positionBar_Scroll(object sender, System.EventArgs e)
		{
			axWindowsMediaPlayer.Ctlcontrols.currentPosition = positionBar.Value;
		}
	}
}
