using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Configuration;

namespace LogView
{
	/// <summary>
	/// LogView lets you look at IIS log files through your
	/// browser.  Nothing is done with the data other than
	/// filtering out /default.ida since typically there
	/// are hundreds or thousands of hits on this URL by viruses
	/// and it clogs up the display.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DropDownList LogFileDropDownList;
		protected System.Web.UI.WebControls.DataGrid StatsGrid;
		protected System.Web.UI.WebControls.DataGrid LogGrid;

		// These are loaded from the <appSettings> section
		// of web.config.  The required bit looks like
		// this:
		//
		//		<appSettings>
		//			<add key="logpath" value="c:\winnt\system32\logfiles\w3c"/>
		//			<add key="logpattern" value="*.log"/>
		//		</appSettings>
		string LogPath;
		string LogFilePattern;

		private void Page_Load(object sender, System.EventArgs e)
		{
			LogPath = ConfigurationSettings.AppSettings["logpath"].ToString();
			LogFilePattern = ConfigurationSettings.AppSettings["logpattern"].ToString();

			if (!IsPostBack)
			{
				// Put user code to initialize the page here
				string[] fileList = Directory.GetFiles(LogPath, LogFilePattern);
				foreach (string logFile in fileList)
				{
					int sepIdx = logFile.LastIndexOf('\\');
					string workFile = logFile;
					if (sepIdx > 0)
					{
						// Keep the part after the separator
						workFile = logFile.Substring(sepIdx+1);
					}

					LogFileDropDownList.Items.Insert(0, workFile);
				}

				if (LogFileDropDownList.Items.Count > 0)
				{
					Populate(LogFileDropDownList.Items[0].Text);
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.LogFileDropDownList.SelectedIndexChanged += new System.EventHandler(this.OnSelectedIndexChanged);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		void Populate(string logFile)
		{
			string logPath = LogPath + "\\" + logFile;

			// Open the log file; must open with sharing since the server
			// may still be writing to it
			FileStream logStream = File.Open(logPath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
			StreamReader rdr = new StreamReader(logStream);

			DataSet ds = new DataSet("LogData");
			DataTable statsTable = new DataTable("LogStats");
			DataTable detailTable = new DataTable("LogDetail");
			ds.Tables.Add(statsTable);
			ds.Tables.Add(detailTable);

			int stemField = -1;
			int badDefaultIda = 0;
			int numHits = 0;
			while (true)
			{
				string str = rdr.ReadLine();
				if (str == null)
				{
					break;
				};

				// No columns yet, we must be in the header part
				if (detailTable.Columns.Count == 0)
				{
					string[] fields = str.Split(" ".ToCharArray());
					if (fields.Length > 0 && fields[0] == "#Fields:")
					{
						// We've found the field list
						for (int i=1; i<fields.Length; i++)
						{
							if (fields[i] == "cs-uri-stem")
							{
								stemField = i-1;
							}

							DataColumn dc = new DataColumn(fields[i]);
							detailTable.Columns.Add(dc);
						};
					};
				};

				if (!str.StartsWith("#"))
				{
					if (detailTable.Columns.Count == 0)
					{
						Response.Write("Invalid log file; looks like it's not the correct format.");
						Response.End();
					};

					DataRow row = detailTable.NewRow();
					string[] fields = str.Split(" ".ToCharArray());
					if (fields.Length == detailTable.Columns.Count-1)
					{
						if ((stemField != -1) && (fields[stemField] == "/default.ida"))
						{ 
							badDefaultIda++;
						} 
						else
						{
							for (int i=0; i<fields.Length; i++)
							{
								row[i] = fields[i];
							}

							detailTable.Rows.Add(row);
						}

						numHits++;
					}
				};
			}

			LogGrid.Columns.Clear();
			LogGrid.DataSource = detailTable;
			LogGrid.DataBind();

			statsTable.Columns.Add("Name");
			statsTable.Columns.Add("Value");
			statsTable.Rows.Add(new string[] { "Total Hits", numHits.ToString() });
			statsTable.Rows.Add(new string[] { "/default.ida skipped", badDefaultIda.ToString() });

			StatsGrid.DataSource = statsTable;
			StatsGrid.DataBind();
		}

		private void OnSelectedIndexChanged(object sender, System.EventArgs e)
		{
			Populate(LogFileDropDownList.SelectedItem.Text);
		}
	}
}
